/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.functionality.index.solr.cql;

import eu.dnetlib.functionality.index.cql.CqlValueTransformerMap;
import eu.dnetlib.miscutils.functional.IdentityFunction;
import eu.dnetlib.miscutils.functional.UnaryFunction;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.solr.common.SolrException;
import org.apache.solr.schema.IndexSchema;
import org.apache.solr.schema.SchemaField;

public class SolrTypeBasedCqlValueTransformerMap
implements CqlValueTransformerMap {
    private static final Log log = LogFactory.getLog(SolrTypeBasedCqlValueTransformerMap.class);
    private IndexSchema schema;
    private Map<String, UnaryFunction<String, String>> transformerMap;

    public SolrTypeBasedCqlValueTransformerMap(IndexSchema indexSchema, Map<String, UnaryFunction<String, String>> transformerMap) {
        this.schema = indexSchema;
        this.transformerMap = transformerMap;
    }

    public UnaryFunction<String, String> transformerFor(String fieldName) {
        try {
            UnaryFunction<String, String> res;
            SchemaField field = this.schema.getField(fieldName);
            if (field != null && (res = this.transformerMap.get(field.getType().getTypeName())) != null) {
                return res;
            }
        }
        catch (SolrException e) {
            log.debug((Object)"cannot find field", (Throwable)e);
        }
        return new IdentityFunction();
    }
}

