/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.functionality.index.solr.feed;

import eu.dnetlib.functionality.index.solr.feed.IndexDocument;
import eu.dnetlib.functionality.index.solr.feed.IndexDocumentCallback;
import eu.dnetlib.functionality.index.solr.utils.IndexMap;
import eu.dnetlib.miscutils.dom4j.XPathHelper;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.text.ParseException;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpException;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.solr.common.util.DateUtil;
import org.apache.solr.schema.TrieDateField;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.dom4j.Node;
import org.dom4j.io.SAXReader;

public class InputDocumentFactory {
    private static final Log log = LogFactory.getLog(InputDocumentFactory.class);
    private static String XPATH_TARGETFIELDS = "//indexRecord/targetFields/*";
    private static String XPATH_RESULTFIELD = "//indexRecord/result";
    private static String XPATH_INDEX_RECORD_ID = "//indexRecord/indexRecordIdentifier";
    private static String XPATH_FULLTEXT_LINK = "//indexRecord/fullText";

    public IndexDocument getInputDocument(IndexDocumentCallback callback, String version, String inputDocument) throws DocumentException {
        return this.parseDocument(callback, version, inputDocument);
    }

    protected IndexDocument parseDocument(IndexDocumentCallback callback, String version, String inputDocument) throws DocumentException {
        try {
            if (inputDocument == null || inputDocument.isEmpty()) {
                throw new DocumentException("empty document");
            }
            Element doc = new SAXReader().read((Reader)new StringReader(inputDocument)).getRootElement();
            String recordId = XPathHelper.selectElement((Node)doc, (String)XPATH_INDEX_RECORD_ID).getText();
            IndexDocument indexDocument = callback.get(recordId);
            if (version != null) {
                indexDocument.addField(IndexMap.DS_VERSION, this.getParsedDateField(version));
            }
            indexDocument.addField(IndexMap.INDEX_RECORD_ID, recordId);
            indexDocument.addField(IndexMap.RESULT, XPathHelper.selectElement((Node)doc, (String)XPATH_RESULTFIELD).asXML());
            Iterable targetFields = XPathHelper.selectElements((Node)doc, (String)XPATH_TARGETFIELDS);
            if (targetFields.iterator().hasNext()) {
                for (Element field : targetFields) {
                    indexDocument.addField(field.getName().toLowerCase(), field.getText());
                }
                return indexDocument.setOK();
            }
            log.info((Object)"marking document for post-feed deletion");
            return indexDocument.setMarked();
        }
        catch (ParseException e) {
            throw new IllegalArgumentException("unable to parse field: " + version, e);
        }
        catch (DocumentException e) {
            throw new IllegalArgumentException("skipping invalid document", e);
        }
    }

    public IndexDocument getFullTextDocument(IndexDocument indexDocument, String fullTextMetadata) {
        try {
            Element doc = new SAXReader().read((Reader)new StringReader(fullTextMetadata)).getRootElement();
            String indexRecordId = XPathHelper.selectElement((Node)doc, (String)XPATH_INDEX_RECORD_ID).getText();
            String fullTextLink = XPathHelper.selectElement((Node)doc, (String)XPATH_FULLTEXT_LINK).getText();
            log.debug((Object)("indexRecordId: " + indexRecordId));
            log.debug((Object)("fullTextLink: " + fullTextLink));
            HttpClient client = new HttpClient();
            GetMethod method = new GetMethod(fullTextLink);
            client.executeMethod((HttpMethod)method);
            if (method.getStatusCode() != 200) {
                return indexDocument.setError(new HttpException("" + method.getStatusCode()));
            }
            indexDocument.setField(IndexMap.FULLTEXT_ID, method.getResponseBodyAsString());
            indexDocument.setField(IndexMap.INDEX_RECORD_ID, indexRecordId);
            if (log.isDebugEnabled()) {
                log.debug((Object)("IndexDocument is FULLTEXT ready: " + indexDocument.toString()));
            }
            return indexDocument.setOK();
        }
        catch (DocumentException e) {
            log.warn((Object)"skipping invalid metadata", (Throwable)e);
            return indexDocument.setError(e);
        }
        catch (HttpException e) {
            log.warn((Object)"unable to retrieve fullText", (Throwable)e);
            return indexDocument.setError(e);
        }
        catch (IOException e) {
            log.warn((Object)"unable to retrieve fullText", (Throwable)e);
            return indexDocument.setError(e);
        }
    }

    public String getParsedDateField(String date) throws ParseException {
        return new TrieDateField().toExternal(DateUtil.parseDate((String)date));
    }
}

