/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.functionality.index.solr.feed;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import eu.dnetlib.functionality.index.solr.feed.IndexDocument;
import eu.dnetlib.functionality.index.solr.feed.IndexDocumentCallback;
import eu.dnetlib.functionality.index.solr.feed.StreamingInputDocumentFactory;
import eu.dnetlib.functionality.index.solr.utils.IndexMap;
import java.io.IOException;
import java.io.StringReader;
import java.io.StringWriter;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLEventFactory;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLEventWriter;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.Attribute;
import javax.xml.stream.events.Namespace;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpConnectionManager;
import org.apache.commons.httpclient.HttpException;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.MultiThreadedHttpConnectionManager;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dom4j.DocumentException;

public class StreamingUpdateInputDocumentFactory
extends StreamingInputDocumentFactory {
    private static final Log log = LogFactory.getLog(StreamingUpdateInputDocumentFactory.class);
    protected static final String IS_UPDATE = "update";
    protected static final String IS_EXTERNAL = "external";
    protected static final String UPDATE_MODE = "updateMode";
    private HttpClient httpClient = new HttpClient((HttpConnectionManager)new MultiThreadedHttpConnectionManager());

    @Override
    protected IndexDocument parseDocument(IndexDocumentCallback callback, String version, String inputDocument) throws DocumentException {
        String recordId = null;
        IndexDocument indexDocument = null;
        try {
            StringWriter results = new StringWriter();
            XMLEventReader parser = ((XMLInputFactory)this.inputFactory.get()).createXMLEventReader(new StringReader(inputDocument));
            while (parser.hasNext()) {
                XMLEvent event = parser.nextEvent();
                if (event == null || !event.isStartElement()) continue;
                String localName = event.asStartElement().getName().getLocalPart();
                if ("indexRecordIdentifier".equals(localName)) {
                    XMLEvent text = parser.nextEvent();
                    recordId = this.getText(text);
                    indexDocument = callback.get(recordId);
                    indexDocument.addField(IndexMap.INDEX_RECORD_ID, recordId);
                    continue;
                }
                if ("targetFields".equals(localName)) {
                    this.parseTargetFields(indexDocument, parser);
                    continue;
                }
                if (!"result".equals(localName)) continue;
                this.copyResult(indexDocument, results, parser);
            }
            if (version != null) {
                indexDocument.addField(IndexMap.DS_VERSION, this.getParsedDateField(version));
            }
            return IndexDocument.STATUS.MARKED.equals((Object)indexDocument.getStatus()) ? indexDocument : indexDocument.setOK();
        }
        catch (XMLStreamException e) {
            log.warn((Object)("Parse exception in doc " + inputDocument), (Throwable)e);
            throw new DocumentException((Throwable)e);
        }
        catch (ParseException e) {
            throw new IllegalArgumentException("unable to parse field: " + version, e);
        }
    }

    @Override
    protected void parseTargetFields(IndexDocument indexDocument, XMLEventReader parser) throws XMLStreamException {
        XMLEvent targetEvent;
        boolean hasFields = false;
        HashMap refreshFields = Maps.newHashMap();
        while (!(!parser.hasNext() || (targetEvent = parser.nextEvent()).isEndElement() && targetEvent.asEndElement().getName().getLocalPart().equals("targetFields"))) {
            if (!targetEvent.isStartElement()) continue;
            StartElement startElement = targetEvent.asStartElement();
            String fieldName = startElement.getName().getLocalPart();
            String data = this.getText(parser.nextEvent());
            UpdateModes mode = this.parseUpdateMode(startElement);
            boolean isExternal = this.getAttributeValue(targetEvent, IS_EXTERNAL);
            this.addField(indexDocument, fieldName, data, mode, isExternal, refreshFields);
            hasFields = true;
        }
        if (!refreshFields.isEmpty()) {
            for (Map.Entry e : refreshFields.entrySet()) {
                indexDocument.setField((String)e.getKey(), e.getValue());
            }
        }
        if (!hasFields) {
            indexDocument.setMarked();
        }
    }

    private final void addField(IndexDocument indexDocument, String field, String value, UpdateModes mode, boolean isExternal, Map<String, List<String>> refreshFields) {
        String trimmed = value.trim();
        if (!trimmed.isEmpty()) {
            String fieldValue = isExternal ? this.getExternalField(trimmed) : trimmed;
            switch (mode) {
                case refresh: {
                    if (refreshFields.get(field) == null) {
                        refreshFields.put(field, new ArrayList());
                    }
                    refreshFields.get(field).add(fieldValue);
                    break;
                }
                case append: {
                    indexDocument.addField(field.toLowerCase(), fieldValue);
                    break;
                }
                default: {
                    indexDocument.addField(field.toLowerCase(), fieldValue);
                    break;
                }
            }
        } else {
            log.debug((Object)("found empty target field: " + field));
        }
    }

    @Override
    protected void copyResult(IndexDocument indexDocument, StringWriter results, XMLEventReader parser) throws XMLStreamException {
        XMLEventWriter writer = ((XMLOutputFactory)this.outputFactory.get()).createXMLEventWriter(results);
        ArrayList namespaces = Lists.newArrayList((Object[])new Namespace[]{((XMLEventFactory)this.eventFactory.get()).createNamespace("dri", "http://www.driver-repository.eu/namespace/dri"), ((XMLEventFactory)this.eventFactory.get()).createNamespace("dr", "http://www.driver-repository.eu/namespace/dr"), ((XMLEventFactory)this.eventFactory.get()).createNamespace("xsi", "http://www.w3.org/2001/XMLSchema-instance"), ((XMLEventFactory)this.eventFactory.get()).createNamespace("dc", "http://purl.org/dc/elements/1.1/")});
        StartElement newRecord = ((XMLEventFactory)this.eventFactory.get()).createStartElement("", null, "result", null, namespaces.iterator());
        writer.add(newRecord);
        while (parser.hasNext()) {
            XMLEvent resultEvent = parser.nextEvent();
            if (resultEvent.isEndElement() && resultEvent.asEndElement().getName().getLocalPart().equals("result")) {
                writer.add(resultEvent);
                break;
            }
            writer.add(resultEvent);
        }
        writer.close();
        indexDocument.addField(IndexMap.RESULT, results);
    }

    private String getExternalField(String link) {
        try {
            URL url = new URL(link);
            GetMethod get = new GetMethod();
            get.setPath(url.toExternalForm());
            this.httpClient.executeMethod((HttpMethod)get);
            return get.getResponseBodyAsString();
        }
        catch (MalformedURLException e) {
            throw new IllegalArgumentException("malformed URL: " + link, e);
        }
        catch (HttpException e) {
            log.warn((Object)("Unable to get external field from: " + link), (Throwable)e);
            return "";
        }
        catch (IOException e) {
            log.warn((Object)("Unable to get external field from: " + link), (Throwable)e);
            return "";
        }
    }

    private boolean getAttributeValue(XMLEvent event, String attributeName) {
        Attribute attr = event.asStartElement().getAttributeByName(new QName(attributeName));
        if (attr != null) {
            return Boolean.parseBoolean(attr.getValue());
        }
        return false;
    }

    private UpdateModes parseUpdateMode(StartElement startElement) {
        Attribute attr = startElement.getAttributeByName(new QName(UPDATE_MODE));
        if (attr != null) {
            return UpdateModes.valueOf(attr.getValue());
        }
        return UpdateModes.append;
    }

    protected static enum UpdateModes {
        refresh,
        append;

    }
}

