/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.functionality.index.solr.feed.local;

import eu.dnetlib.functionality.index.solr.feed.local.FileWalker;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class BlockingStream<T>
implements Iterator<T> {
    private static final Log log = LogFactory.getLog(BlockingStream.class);
    private BlockingQueue<T> queue;
    private T nextReturn;
    private boolean hasNext = true;

    public BlockingStream(BlockingQueue<T> queue) {
        this.queue = queue;
    }

    @Override
    public boolean hasNext() {
        while (this.nextReturn == null) {
            try {
                this.nextReturn = this.queue.poll(2L, TimeUnit.SECONDS);
            }
            catch (InterruptedException e) {
                log.error((Object)"ops... ", (Throwable)e);
                return false;
            }
            if (FileWalker.done != this.nextReturn) continue;
            this.hasNext = false;
        }
        return this.hasNext;
    }

    @Override
    public T next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        T retVal = this.nextReturn;
        this.nextReturn = null;
        return retVal;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("Not available.");
    }
}

