/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.functionality.index.solr.resultset;

import eu.dnetlib.data.index.IndexServiceException;
import eu.dnetlib.enabling.resultset.ResultSetListener;
import eu.dnetlib.functionality.index.solr.SolrIndexServer;
import eu.dnetlib.functionality.index.solr.query.IndexQuery;
import eu.dnetlib.functionality.index.solr.query.QueryResponseParser;
import eu.dnetlib.functionality.index.solr.resultset.ResultsCache;
import eu.dnetlib.functionality.index.solr.utils.MetadataReference;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class IndexResultSetListener
implements ResultSetListener {
    private static final Log log = LogFactory.getLog(IndexResultSetListener.class);
    protected ResultsCache cache = null;
    protected Long size = null;
    protected IndexQuery indexQuery;
    protected MetadataReference mdRef;
    protected SolrIndexServer solrIndexServer;

    protected abstract List<String> getContextualResult(QueryResponseParser var1, int var2, int var3);

    protected abstract IndexQuery getContextualQuery(IndexQuery var1, int var2, int var3);

    protected abstract int getContextualSize();

    protected IndexResultSetListener(IndexQuery indexQuery, MetadataReference mdRef, SolrIndexServer solrIndexServer) throws IndexServiceException {
        this.indexQuery = indexQuery;
        this.mdRef = mdRef;
        this.solrIndexServer = solrIndexServer;
    }

    public List<String> getResult(int from, int to) {
        return this.getContextualResult(this.performQuery(from, to), from, to);
    }

    public int getSize() {
        return this.getContextualSize();
    }

    protected QueryResponseParser performQuery(int from, int to) {
        try {
            return this.solrIndexServer.lookup(this.getContextualQuery(this.indexQuery, from, to), this.mdRef);
        }
        catch (Exception e) {
            log.error((Object)"ops... cannot perform query", (Throwable)e);
            throw new RuntimeException(e);
        }
    }
}

