/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.functionality.index.solr.resultset;

import eu.dnetlib.data.index.IndexServiceException;
import eu.dnetlib.functionality.index.solr.SolrIndexServer;
import eu.dnetlib.functionality.index.solr.query.IndexQuery;
import eu.dnetlib.functionality.index.solr.query.QueryResponseParser;
import eu.dnetlib.functionality.index.solr.resultset.IndexResultSetListener;
import eu.dnetlib.functionality.index.solr.utils.MetadataReference;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class LookupResultSetListener
extends IndexResultSetListener {
    private static final Log log = LogFactory.getLog(LookupResultSetListener.class);

    public LookupResultSetListener(IndexQuery indexQuery, MetadataReference mdRef, SolrIndexServer solrIndexServer) throws IndexServiceException {
        super(indexQuery, mdRef, solrIndexServer);
        log.debug((Object)"LookupResultSetListener is up!");
    }

    @Override
    protected List<String> getContextualResult(QueryResponseParser responseParser, int from, int to) {
        return responseParser.getResults();
    }

    @Override
    protected IndexQuery getContextualQuery(IndexQuery indexQuery, int from, int to) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("getContextualResult LOOKUP - from:" + from + " to: " + to));
            log.debug((Object)("indexQuery.setStart(" + (from - 1) + ").setRows(" + (to - from + 1) + ")"));
        }
        indexQuery.setStart(from - 1).setRows(Integer.valueOf(to - from + 1));
        return indexQuery;
    }

    @Override
    protected int getContextualSize() {
        if (this.size == null) {
            try {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("setting LookupResultSetListener size with query: " + this.indexQuery.toString()));
                }
                this.indexQuery.setRows(0);
                this.size = this.solrIndexServer.lookup(this.indexQuery, this.mdRef).getNumFound();
            }
            catch (Throwable e) {
                log.error((Object)"ops getResult", e);
                throw new RuntimeException(e);
            }
        }
        return this.size.intValue();
    }
}

