/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.functionality.index.solr.rmi;

import eu.dnetlib.functionality.index.solr.query.QueryLanguage;
import eu.dnetlib.functionality.index.solr.rmi.SolrParamsTranslator;
import eu.dnetlib.functionality.index.solr.rmi.SolrRequestInfo;
import eu.dnetlib.functionality.index.solr.utils.IndexMap;
import eu.dnetlib.functionality.index.solr.utils.MetadataReference;
import eu.dnetlib.functionality.index.solr.utils.MetadataReferenceFactory;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Map;
import java.util.WeakHashMap;
import javax.annotation.Resource;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.common.util.SimpleOrderedMap;
import org.apache.solr.core.Config;
import org.apache.solr.core.CoreContainer;
import org.apache.solr.core.SolrConfig;
import org.apache.solr.core.SolrCore;
import org.apache.solr.handler.admin.CoreAdminHandler;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.request.SolrRequestHandler;
import org.apache.solr.response.BinaryQueryResponseWriter;
import org.apache.solr.response.QueryResponseWriter;
import org.apache.solr.response.SolrQueryResponse;
import org.apache.solr.servlet.SolrRequestParsers;
import org.apache.solr.servlet.cache.HttpCacheHeaderUtil;
import org.apache.solr.servlet.cache.Method;
import org.xml.sax.InputSource;

public class ServletRequestHandler {
    private static final Log log = LogFactory.getLog(ServletRequestHandler.class);
    @Resource
    private IndexMap indexMap;
    @Resource
    private MetadataReferenceFactory mdFactory;
    @Resource
    private SolrParamsTranslator paramsTranslator;
    protected String pathPrefix = "/index";
    protected String pathSplit = ".do/";
    protected String abortErrorMessage = null;
    protected String solrConfigFilename = null;
    protected final Map<SolrConfig, SolrRequestParsers> parsers = new WeakHashMap<SolrConfig, SolrRequestParsers>();
    protected final SolrRequestParsers adminRequestParser;

    public ServletRequestHandler() {
        try {
            this.adminRequestParser = new SolrRequestParsers(new Config(null, "solr", new InputSource(new ByteArrayInputStream("<root/>".getBytes("UTF-8"))), ""));
        }
        catch (Exception e) {
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleRequest(ServletRequest request, ServletResponse response, QueryLanguage lang) throws IOException {
        if (this.abortErrorMessage != null) {
            ((HttpServletResponse)response).sendError(500, this.abortErrorMessage);
            return;
        }
        if (request instanceof HttpServletRequest) {
            HttpServletRequest req = (HttpServletRequest)request;
            HttpServletResponse resp = (HttpServletResponse)response;
            CoreAdminHandler handler = null;
            SolrQueryRequest solrReq = null;
            SolrCore core = null;
            String corename = "";
            try {
                int idx;
                String path = req.getPathInfo();
                corename = this.getCoreNameFromPath(path);
                MetadataReference mdRef = this.mdFactory.decodeMetadata(corename);
                CoreContainer cores = this.indexMap.getCoreContainer(mdRef);
                if (cores == null) {
                    throw new IllegalStateException("index doesn't exist: " + corename);
                }
                req.setAttribute("org.apache.solr.CoreContainer", (Object)cores);
                path = path.substring(path.lastIndexOf(this.pathSplit) + 3);
                String alternate = cores.getManagementPath();
                if (alternate != null && path.startsWith(alternate)) {
                    path = path.substring(0, alternate.length());
                }
                if ((idx = path.indexOf(58)) > 0) {
                    path = path.substring(0, idx);
                }
                if (path.equals(cores.getAdminPath())) {
                    handler = cores.getMultiCoreHandler();
                    solrReq = this.adminRequestParser.parse(null, path, req);
                    this.handleAdminRequest(req, response, (SolrRequestHandler)handler, solrReq);
                    return;
                }
                core = cores.getCore(corename);
                if (core == null) {
                    corename = "";
                    core = cores.getCore("");
                }
                log.debug((Object)("\n cores: " + cores.getCoreNames() + "\n core: " + core + "\n corename: " + corename + "\n path: " + path));
                if (core != null) {
                    String qt;
                    SolrConfig config = core.getSolrConfig();
                    SolrRequestParsers parser = null;
                    parser = this.parsers.get(config);
                    if (parser == null) {
                        parser = new SolrRequestParsers((Config)config);
                        this.parsers.put(config, parser);
                    }
                    if (handler == null && path.length() > 1 && (handler = core.getRequestHandler(path)) == null && parser.isHandleSelect() && ("/select".equals(path) || "/select/".equals(path)) && (handler = core.getRequestHandler(qt = (solrReq = parser.parse(core, path, req)).getParams().get("qt"))) == null) {
                        throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "unknown handler: " + qt);
                    }
                    if (handler != null) {
                        if (solrReq == null) {
                            solrReq = parser.parse(core, path, req);
                        }
                        Method reqMethod = Method.getMethod((String)req.getMethod());
                        HttpCacheHeaderUtil.setCacheControlHeader((SolrConfig)config, (HttpServletResponse)resp, (Method)reqMethod);
                        if (config.getHttpCachingConfig().isNever304() || !HttpCacheHeaderUtil.doCacheHeaderValidation((SolrQueryRequest)solrReq, (HttpServletRequest)req, (Method)reqMethod, (HttpServletResponse)resp)) {
                            SolrQueryResponse solrRsp = new SolrQueryResponse();
                            SolrRequestInfo.setRequestInfo(new SolrRequestInfo(solrReq, solrRsp));
                            switch (lang) {
                                case CQL: {
                                    solrReq.setParams(this.paramsTranslator.evaluate(solrReq.getParams(), mdRef));
                                    break;
                                }
                            }
                            this.execute(req, (SolrRequestHandler)handler, solrReq, solrRsp);
                            HttpCacheHeaderUtil.checkHttpCachingVeto((SolrQueryResponse)solrRsp, (HttpServletResponse)resp, (Method)reqMethod);
                            QueryResponseWriter responseWriter = core.getQueryResponseWriter(solrReq);
                            this.writeResponse(solrRsp, response, responseWriter, solrReq, reqMethod);
                        }
                        return;
                    }
                    req.setAttribute("org.apache.solr.SolrCore", (Object)core);
                    if (path.startsWith("/admin")) {
                        req.getRequestDispatcher(this.pathPrefix == null ? path : this.pathPrefix + path).forward(request, response);
                        return;
                    }
                }
                log.debug((Object)("no handler or core retrieved for " + path + ", follow through..."));
            }
            catch (Throwable e) {
                this.sendError((HttpServletResponse)response, e);
                return;
            }
            finally {
                if (solrReq != null) {
                    solrReq.close();
                }
                if (core != null) {
                    core.close();
                }
                SolrRequestInfo.clearRequestInfo();
            }
        }
    }

    private String getCoreNameFromPath(String path) {
        String corename = "";
        if (path.startsWith(this.pathPrefix)) {
            corename = path.replaceFirst(this.pathPrefix, "");
            int idxSplit = corename.indexOf("/", 1);
            corename = corename.substring(1, idxSplit);
        }
        return corename;
    }

    private void handleAdminRequest(HttpServletRequest req, ServletResponse response, SolrRequestHandler handler, SolrQueryRequest solrReq) throws IOException {
        SolrQueryResponse solrResp = new SolrQueryResponse();
        SimpleOrderedMap responseHeader = new SimpleOrderedMap();
        solrResp.add("responseHeader", (Object)responseHeader);
        NamedList toLog = solrResp.getToLog();
        toLog.add("webapp", (Object)req.getContextPath());
        toLog.add("path", solrReq.getContext().get("path"));
        toLog.add("params", (Object)("{" + solrReq.getParamString() + "}"));
        handler.handleRequest(solrReq, solrResp);
        SolrCore.setResponseHeaderValues((SolrRequestHandler)handler, (SolrQueryRequest)solrReq, (SolrQueryResponse)solrResp);
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < toLog.size(); ++i) {
            String name = toLog.getName(i);
            Object val = toLog.getVal(i);
            sb.append(name).append("=").append(val).append(" ");
        }
        QueryResponseWriter respWriter = (QueryResponseWriter)SolrCore.DEFAULT_RESPONSE_WRITERS.get(solrReq.getParams().get("wt"));
        if (respWriter == null) {
            respWriter = (QueryResponseWriter)SolrCore.DEFAULT_RESPONSE_WRITERS.get("standard");
        }
        this.writeResponse(solrResp, response, respWriter, solrReq, Method.getMethod((String)req.getMethod()));
    }

    private void writeResponse(SolrQueryResponse solrRsp, ServletResponse response, QueryResponseWriter responseWriter, SolrQueryRequest solrReq, Method reqMethod) throws IOException {
        if (solrRsp.getException() != null) {
            this.sendError((HttpServletResponse)response, solrRsp.getException());
        } else {
            String ct = responseWriter.getContentType(solrReq, solrRsp);
            if (null != ct) {
                response.setContentType(ct);
            }
            if (Method.HEAD != reqMethod) {
                if (responseWriter instanceof BinaryQueryResponseWriter) {
                    BinaryQueryResponseWriter binWriter = (BinaryQueryResponseWriter)responseWriter;
                    binWriter.write((OutputStream)response.getOutputStream(), solrReq, solrRsp);
                } else {
                    responseWriter.write((Writer)response.getWriter(), solrReq, solrRsp);
                }
            }
        }
    }

    protected void execute(HttpServletRequest req, SolrRequestHandler handler, SolrQueryRequest sreq, SolrQueryResponse rsp) {
        sreq.getContext().put("webapp", req.getContextPath());
        sreq.getCore().execute(handler, sreq, rsp);
    }

    protected void sendError(HttpServletResponse res, Throwable ex) throws IOException {
        int code = 500;
        String trace = "";
        if (ex instanceof SolrException) {
            code = ((SolrException)ex).code();
        }
        if (code == 500 || code < 100) {
            StringWriter sw = new StringWriter();
            ex.printStackTrace(new PrintWriter(sw));
            trace = "\n\n" + sw.toString();
            log.fatal((Object)log, ex);
            if (code < 100) {
                log.warn((Object)("invalid return code: " + code));
                code = 500;
            }
        }
        res.sendError(code, ex.getMessage() + trace);
    }
}

