/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.functionality.index.solr.rmi;

import com.google.common.base.Function;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import com.google.inject.internal.Lists;
import eu.dnetlib.data.index.IndexServiceException;
import eu.dnetlib.functionality.index.solr.query.BaseQueryFactory;
import eu.dnetlib.functionality.index.solr.utils.MetadataReference;
import java.util.List;
import java.util.Set;
import javax.annotation.Resource;
import org.apache.solr.common.params.ModifiableSolrParams;
import org.apache.solr.common.params.SolrParams;
import org.springframework.beans.factory.annotation.Required;

public class SolrParamsTranslator {
    @Resource
    private transient BaseQueryFactory baseQueryFactory;
    private List<String> paramsToTranslate;

    public SolrParams evaluate(SolrParams params, final MetadataReference mdRef) {
        ModifiableSolrParams solrParams = new ModifiableSolrParams(params);
        Sets.SetView names = Sets.intersection((Set)Sets.newHashSet((Iterable)solrParams.getParameterNames()), (Set)Sets.newHashSet((Object[])this.getParamsToTranslate()));
        for (final String name : names) {
            Iterable newParams = Iterables.transform((Iterable)Lists.newArrayList((Object[])solrParams.remove(name)), (Function)new Function<String, String>(){

                public String apply(String param) {
                    try {
                        return SolrParamsTranslator.this.baseQueryFactory.newInstance(param, mdRef).get(name);
                    }
                    catch (IndexServiceException e) {
                        throw new IllegalArgumentException(e);
                    }
                }
            });
            for (String p : newParams) {
                solrParams.add(name, new String[]{p});
            }
        }
        return solrParams;
    }

    public String[] getParamsToTranslate() {
        return (String[])Iterables.toArray(this.paramsToTranslate, String.class);
    }

    @Required
    public void setParamsToTranslate(String[] paramsToTranslate) {
        this.paramsToTranslate = Lists.newArrayList((Object[])paramsToTranslate);
    }
}

