/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.functionality.index.solr.utils;

import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import eu.dnetlib.data.index.IndexServiceException;
import eu.dnetlib.functionality.index.solr.utils.ClasspathResourceLoader;
import eu.dnetlib.functionality.index.solr.utils.IndexSchemaFactory;
import eu.dnetlib.miscutils.collections.MappedCollection;
import eu.dnetlib.miscutils.dom4j.XPathHelper;
import eu.dnetlib.miscutils.functional.UnaryFunction;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.xml.parsers.ParserConfigurationException;
import org.antlr.stringtemplate.StringTemplate;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.lucene.util.Version;
import org.apache.solr.core.SolrConfig;
import org.apache.solr.schema.IndexSchema;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.dom4j.Node;
import org.dom4j.io.SAXReader;
import org.springframework.beans.factory.annotation.Required;
import org.springframework.core.io.Resource;
import org.xml.sax.SAXException;

public class InitUtils {
    private static final String SOLR_XML = "solr.xml";
    private static final String SOLRCONFIG_XML = "solrconfig.xml";
    private static final Log log = LogFactory.getLog(InitUtils.class);
    private static String configDir = "/conf";
    private transient String solrHomeDir;
    private String solrDataDir;
    private String solrConfVersion;
    private boolean overwriteConf;
    private boolean clusteringEnabled;
    private String queryComponent;
    private String serviceBaseurl;
    private StringTemplate solrConfig;
    private StringTemplate coreConfig;
    private IndexSchemaFactory schemaFactory;
    private transient ClasspathResourceLoader resourceLoader;

    public void init() throws IndexServiceException {
        this.buildConfigurationBase(this.solrHomeDir);
        this.refreshConfig();
    }

    public List<String> getExistingIndexNames() {
        File fileDataDir = new File(this.solrDataDir);
        ArrayList indexNames = Lists.newArrayList();
        if (fileDataDir.exists()) {
            for (File indexDir : fileDataDir.listFiles()) {
                indexNames.add(indexDir.getName());
            }
        }
        return indexNames;
    }

    public List<String> listIndexFiles(String indexName) {
        ArrayList files = Lists.newArrayList();
        File indexDir = new File(this.solrDataDir + "/" + indexName + "/index");
        if (indexDir.isDirectory()) {
            Iterables.addAll((Collection)files, (Iterable)new MappedCollection((Object[])indexDir.listFiles(), (UnaryFunction)new UnaryFunction<String, File>(){

                public String evaluate(File file) {
                    return StringEscapeUtils.escapeHtml((String)(InitUtils.this.serviceBaseurl + "/indexfilelist.do" + file.getAbsolutePath().replace(InitUtils.this.solrDataDir, "")));
                }
            }));
        }
        log.debug((Object)(indexName + " files: " + files));
        return files;
    }

    public void buildConfiguration(String indexName, Document fields) throws IndexServiceException {
        File indexFile = this.getIndexDir(indexName);
        if (!indexFile.exists()) {
            String indexPath = indexFile.getAbsolutePath();
            String indexConfDir = indexFile.getAbsolutePath() + configDir;
            indexFile.mkdirs();
            this.buildConfigurationBase(indexPath);
            this.updateSchema(indexName, fields);
            this.write(indexConfDir, new StringReader(this.getSolrConfig(indexName)), SOLRCONFIG_XML);
            this.write(indexPath, new StringReader(this.getCoreConfig(indexName, indexPath)), SOLR_XML);
        }
    }

    private void refreshConfig() throws IndexServiceException {
        for (String indexName : this.getExistingIndexNames()) {
            File indexFile = this.getIndexDir(indexName);
            String indexPath = indexFile.getAbsolutePath();
            String indexConfDir = indexFile.getAbsolutePath() + configDir;
            if (!this.isConfObsolete(indexConfDir + "/" + SOLRCONFIG_XML)) continue;
            log.info((Object)("updating configuration for index " + indexName));
            this.write(indexConfDir, new StringReader(this.getSolrConfig(indexName)), SOLRCONFIG_XML);
            this.write(indexPath, new StringReader(this.getCoreConfig(indexName, indexPath)), SOLR_XML);
        }
    }

    private boolean isConfObsolete(String solrConfig) throws IndexServiceException {
        Document conf = this.parse(solrConfig);
        Element e = XPathHelper.selectElement((Node)conf, (String)"//luceneMatchVersion");
        if (e == null || (e.getText() + "").isEmpty()) {
            return true;
        }
        Version version = Version.valueOf((String)e.getText());
        Version current = Version.valueOf((String)this.getSolrConfVersion());
        log.info((Object)("found solr config file version: " + version.name() + ", required is: " + current.name()));
        return !version.onOrAfter(current);
    }

    private Document parse(String solrConfig) throws IndexServiceException {
        try {
            return new SAXReader().read(new File(solrConfig));
        }
        catch (MalformedURLException e) {
            throw new IndexServiceException((Throwable)e);
        }
        catch (DocumentException e) {
            throw new IndexServiceException((Throwable)e);
        }
    }

    public void updateSchema(String indexName, Document fields) throws IndexServiceException {
        String indexConfDir = this.getIndexDir(indexName).getAbsolutePath() + configDir;
        this.write(indexConfDir, this.schemaFactory.getSchema(fields), "schema.xml");
    }

    private void buildConfigurationBase(String indexDir) throws IndexServiceException {
        if (!new File(this.solrDataDir).mkdirs()) {
            log.info((Object)("found solrDataDir:" + this.solrDataDir));
        }
        if (this.isOverwriteConf()) {
            this.overwriteConf("classpath*:eu/dnetlib/functionality/index/solr/conf/*", new File(indexDir + configDir));
            if (indexDir.equals(this.getSolrHomeDir())) {
                this.buildActorsConf(new File(indexDir + "/actors" + configDir));
            }
        }
    }

    private void overwriteConf(String classpath, File conf) throws IndexServiceException {
        conf.delete();
        conf.mkdirs();
        try {
            for (Resource r : this.resourceLoader.getResources(classpath)) {
                this.write(conf.getAbsolutePath(), new InputStreamReader(r.getInputStream()), r.getFilename());
            }
        }
        catch (IOException e) {
            throw new IndexServiceException((Throwable)e);
        }
    }

    private String getSolrConfig(String indexName) {
        StringTemplate conf = new StringTemplate(this.getSolrConfig().getTemplate());
        conf.setAttribute("indexDataDir", (Object)this.getIndexDir(indexName));
        conf.setAttribute("clusteringEnabled", (Object)this.clusteringEnabled);
        conf.setAttribute("queryComponent", (Object)this.queryComponent);
        return conf.toString();
    }

    private String getCoreConfig(String indexName, String instanceDir) {
        StringTemplate conf = new StringTemplate(this.getCoreConfig().getTemplate());
        conf.setAttribute("indexName", (Object)indexName);
        conf.setAttribute("instanceDir", (Object)instanceDir);
        return conf.toString();
    }

    private void write(String directory, Reader content, String fileName) throws IndexServiceException {
        try {
            File fConfig = new File(directory, fileName);
            FileOutputStream output = new FileOutputStream(fConfig);
            IOUtils.copy((Reader)content, (OutputStream)output);
            output.flush();
            output.close();
        }
        catch (IOException e) {
            throw new IndexServiceException((Throwable)e);
        }
    }

    public IndexSchema getIndexSchema(String indexName) {
        File indexFile = this.getIndexDir(indexName);
        try {
            SolrConfig solrConfigBean = new SolrConfig(indexFile.getAbsolutePath(), SOLRCONFIG_XML, null);
            return new IndexSchema(solrConfigBean, "schema.xml", null);
        }
        catch (ParserConfigurationException e) {
            throw new IllegalStateException(e);
        }
        catch (SAXException e) {
            throw new IllegalStateException(e);
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    private File getIndexDir(String indexName) {
        return new File(this.solrDataDir + '/' + indexName);
    }

    private void buildActorsConf(File conf) throws IndexServiceException {
        this.overwriteConf("classpath*:eu/dnetlib/functionality/index/solr/actors/conf/*", conf);
        System.setProperty("akka.config", conf.getAbsolutePath() + "/akka.conf");
    }

    @Required
    public void setSolrHome(String solrHomeDir) {
        this.solrHomeDir = solrHomeDir;
    }

    public String getSolrHomeDir() {
        return this.solrHomeDir;
    }

    @Required
    public void setSolrDataDir(String solrDataDir) {
        this.solrDataDir = solrDataDir;
    }

    public String getSolrDataDir() {
        return this.solrDataDir;
    }

    @Required
    public void setOverwriteConf(boolean overwriteConf) {
        this.overwriteConf = overwriteConf;
    }

    @Required
    public void setResourceLoader(ClasspathResourceLoader resourceLoader) {
        this.resourceLoader = resourceLoader;
    }

    public boolean isOverwriteConf() {
        return this.overwriteConf;
    }

    @Required
    public void setSolrConfig(StringTemplate solrConfig) {
        this.solrConfig = solrConfig;
    }

    public StringTemplate getSolrConfig() {
        return this.solrConfig;
    }

    @Required
    public void setClusteringEnabled(boolean clusteringEnabled) {
        this.clusteringEnabled = clusteringEnabled;
    }

    public boolean isClusteringEnabled() {
        return this.clusteringEnabled;
    }

    @Required
    public void setCoreConfig(StringTemplate coreConfig) {
        this.coreConfig = coreConfig;
    }

    public StringTemplate getCoreConfig() {
        return this.coreConfig;
    }

    @Required
    public void setSchemaFactory(IndexSchemaFactory schemaFactory) {
        this.schemaFactory = schemaFactory;
    }

    public IndexSchemaFactory getSchemaFactory() {
        return this.schemaFactory;
    }

    @Required
    public void setServiceBaseurl(String serviceBaseurl) {
        this.serviceBaseurl = serviceBaseurl;
    }

    public String getServiceBaseurl() {
        return this.serviceBaseurl;
    }

    @Required
    public void setSolrConfVersion(String solrConfVersion) {
        this.solrConfVersion = solrConfVersion;
    }

    public String getSolrConfVersion() {
        return this.solrConfVersion;
    }

    public String getQueryComponent() {
        return this.queryComponent;
    }

    @Required
    public void setQueryComponent(String queryComponent) {
        this.queryComponent = queryComponent;
    }
}

