/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.functionality.index.solr.utils;

import eu.dnetlib.data.index.IndexServiceException;
import eu.dnetlib.enabling.is.lookup.rmi.ISLookUpDocumentNotFoundException;
import eu.dnetlib.enabling.is.lookup.rmi.ISLookUpException;
import eu.dnetlib.enabling.is.lookup.rmi.ISLookUpService;
import eu.dnetlib.enabling.is.registry.ISRegistryDocumentNotFoundException;
import eu.dnetlib.enabling.is.registry.rmi.ISRegistryException;
import eu.dnetlib.enabling.is.registry.rmi.ISRegistryService;
import eu.dnetlib.enabling.tools.ServiceLocator;
import eu.dnetlib.functionality.index.solr.utils.MetadataReference;
import eu.dnetlib.functionality.index.solr.utils.MetadataReferenceFactory;
import eu.dnetlib.functionality.index.solr.utils.ServiceAddressGetter;
import eu.dnetlib.miscutils.datetime.DateUtils;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Required;

public class ServiceTools {
    private static final Log log = LogFactory.getLog(ServiceTools.class);
    private ServiceAddressGetter serviceAddressGetter;
    private ServiceLocator<ISRegistryService> registryLocator;
    private ServiceLocator<ISLookUpService> lookupLocator;
    @Resource
    private MetadataReferenceFactory mdFactory;

    public List<String> listMDRefs() throws IndexServiceException {
        String xquery = "for $x in //RESOURCE_PROFILE[.//RESOURCE_TYPE/@value='MDFormatDSResourceType'] let $format:= $x//CONFIGURATION/NAME/string() for $y in $x//LAYOUTS/LAYOUT let $layout:= $y//LAYOUT/@name/string() return concat($format,'-',$layout) ";
        return this.quickSearchProfile("for $x in //RESOURCE_PROFILE[.//RESOURCE_TYPE/@value='MDFormatDSResourceType'] let $format:= $x//CONFIGURATION/NAME/string() for $y in $x//LAYOUTS/LAYOUT let $layout:= $y//LAYOUT/@name/string() return concat($format,'-',$layout) ");
    }

    public boolean incrementHandledDataStructures() throws IndexServiceException {
        String xquery = "let $x := //RESOURCE_PROFILE[HEADER/PROTOCOLS/PROTOCOL/@address='" + this.getServiceAddress() + "']," + "$tot := $x//STATUS/HANDLED_DATASTRUCTURE/number() + 1 " + "return update replace $x//STATUS/HANDLED_DATASTRUCTURE with " + "<HANDLED_DATASTRUCTURE>{$tot}</HANDLED_DATASTRUCTURE>";
        log.info((Object)"performing increment of HANDLED_DATASTRUCTURE");
        return this.executeXUpdate(xquery);
    }

    public void refreshServiceLastUpdate() throws IndexServiceException {
        String xquery = "let $x := //RESOURCE_PROFILE[HEADER/PROTOCOLS/PROTOCOL/@address='" + this.getServiceAddress() + "']," + "$date := '" + DateUtils.now_ISO8601() + "' " + "return update replace $x//STATUS/LAST_UPDATE with " + "<LAST_UPDATE value ='{$date}' />";
        log.info((Object)"performing refresh of service LAST_UPDATE");
        this.executeXUpdate(xquery);
    }

    public boolean updateIndexDSSize(String dsId, long size) throws IndexServiceException {
        String xquery = "for $x in collection('')/RESOURCE_PROFILE[.//RESOURCE_IDENTIFIER/@value = '" + dsId + "']" + " return update value $x//INDEX_SIZE with $x//INDEX_SIZE + " + size;
        return this.executeXUpdate(xquery);
    }

    public boolean refreshIndexDSLastUpdate(String dsId) throws IndexServiceException {
        String xquery = "for $x in collection('')/RESOURCE_PROFILE[.//RESOURCE_IDENTIFIER/@value = '" + dsId + "']" + " return update value $x//INDEX_LAST_UPDATE with '" + DateUtils.now_ISO8601() + "' ";
        return this.executeXUpdate(xquery);
    }

    public boolean updateIndexDS(long size, String dsId) throws IndexServiceException {
        String xquery = "for $x in collection('')/RESOURCE_PROFILE[.//RESOURCE_IDENTIFIER/@value = '" + dsId + "']" + " return update value $x//INDEX_SIZE with " + String.valueOf(size) + "," + "for $x in collection('')/RESOURCE_PROFILE[.//RESOURCE_IDENTIFIER/@value = '" + dsId + "']" + " return update value $x//INDEX_LAST_UPDATE with '" + DateUtils.now_ISO8601() + "' ";
        log.debug((Object)("\n\n updating indexDataStructure: " + xquery + "\n\n"));
        return this.executeXUpdate(xquery);
    }

    public MetadataReference getMetadataRef(String dsId) throws IndexServiceException {
        String xquery = "for $x in //RESOURCE_PROFILE[.//RESOURCE_IDENTIFIER/@value='" + dsId + "']//CONFIGURATION " + "return concat(" + "$x/METADATA_FORMAT/text(),'-'," + "$x/METADATA_FORMAT_LAYOUT/text(),'-'," + "$x/METADATA_FORMAT_INTERPRETATION/text())";
        return this.mdFactory.decodeMetadata(this.getResourceProfileByQuery(xquery));
    }

    public String getIndexFields(String dsId) throws IndexServiceException {
        return this.getIndexFields(this.getMetadataRef(dsId));
    }

    public String getIndexFields(MetadataReference mdRef) throws IndexServiceException {
        String xquery = "for $x in collection('')/RESOURCE_PROFILE/BODY[CONFIGURATION/NAME='" + mdRef.getFormat() + "'] return $x/STATUS/LAYOUTS/LAYOUT[@name='" + mdRef.getLayout() + "']/FIELDS";
        return this.getResourceProfileByQuery(xquery);
    }

    public List<String> getIndexDsIdsList(MetadataReference mdRef) throws IndexServiceException {
        String xquery = "for $x in collection('')/RESOURCE_PROFILE[.//METADATA_FORMAT='" + mdRef.getFormat() + "' and .//METADATA_FORMAT_LAYOUT='" + mdRef.getLayout() + "' and .//METADATA_FORMAT_INTERPRETATION='" + mdRef.getInterpretation() + "'] " + "return $x//RESOURCE_IDENTIFIER/@value/string()";
        log.debug((Object)("getting DSIds from IS: " + xquery));
        return this.quickSearchProfile(xquery);
    }

    public List<String> getIndexDsIdsList(String mdFormat, String layout) throws IndexServiceException {
        String xquery = "for $x in collection('')/RESOURCE_PROFILE[.//RESOURCE_TYPE[@value='IndexDSResourceType'] and .//METADATA_FORMAT='" + mdFormat + "' and " + ".//METADATA_FORMAT_LAYOUT='" + layout + "'] " + "return $x//RESOURCE_IDENTIFIER/@value/string()";
        return this.quickSearchProfile(xquery);
    }

    public String[] getIndexDsIdsArray(String mdFormat, String layout) throws IndexServiceException {
        List<String> dsIds = this.getIndexDsIdsList(mdFormat, layout);
        String[] dsIdArray = new String[dsIds.size()];
        return dsIds.toArray(dsIdArray);
    }

    public String[] getIndexDsIdsArray(MetadataReference mdRef) throws IndexServiceException {
        List<String> dsIds = this.getIndexDsIdsList(mdRef);
        String[] dsIdArray = new String[dsIds.size()];
        return dsIds.toArray(dsIdArray);
    }

    public String getIndexLayout() throws IndexServiceException {
        String xquery = "let $i := //RESOURCE_PROFILE[.//RESOURCE_URI/@value='" + this.getServiceAddress() + "?wsdl']," + "$format := $i//METADATA_FORMAT/string()," + "$layout := $i//METADATA_FORMAT_LAYOUT/string()" + "for $x in collection('')/RESOURCE_PROFILE/BODY[CONFIGURATION/NAME=$format] " + "return $x/STATUS/LAYOUTS/LAYOUT[@name=$layout]/FIELDS";
        return this.getResourceProfileByQuery(xquery);
    }

    public List<String> getHandledDataStructureIds() throws IndexServiceException {
        String xquery = "for $x in //RESOURCE_PROFILE[.//RESOURCE_URI/@value='" + this.getServiceAddress() + "?wsdl' and .//RESOURCE_KIND/@value='IndexDSResources'] " + "return $x/HEADER/RESOURCE_IDENTIFIER/@value/string()";
        return this.quickSearchProfile(xquery);
    }

    public boolean deleteIndexDS(String dsId) throws IndexServiceException {
        try {
            return ((ISRegistryService)this.getRegistryLocator().getService()).deleteProfile(dsId);
        }
        catch (ISRegistryDocumentNotFoundException e) {
            throw new IndexServiceException((Throwable)e);
        }
        catch (ISRegistryException e) {
            throw new IndexServiceException((Throwable)e);
        }
    }

    public String getServiceAddress() {
        return this.getServiceAddressGetter().getServiceAddress();
    }

    public String registerProfile(String resourceProfile) throws IndexServiceException {
        try {
            return ((ISRegistryService)this.getRegistryLocator().getService()).registerProfile(resourceProfile);
        }
        catch (ISRegistryException e) {
            throw new IndexServiceException((Throwable)e);
        }
    }

    private List<String> quickSearchProfile(String xquery) throws IndexServiceException {
        try {
            return ((ISLookUpService)this.getLookupLocator().getService()).quickSearchProfile(xquery);
        }
        catch (ISLookUpException e) {
            throw new IndexServiceException((Throwable)e);
        }
    }

    private String getResourceProfileByQuery(String xquery) throws IndexServiceException {
        try {
            return ((ISLookUpService)this.getLookupLocator().getService()).getResourceProfileByQuery(xquery);
        }
        catch (ISLookUpDocumentNotFoundException e) {
            throw new IndexServiceException((Throwable)e);
        }
        catch (ISLookUpException e) {
            throw new IndexServiceException((Throwable)e);
        }
    }

    private boolean executeXUpdate(String xquery) throws IndexServiceException {
        try {
            return ((ISRegistryService)this.getRegistryLocator().getService()).executeXUpdate(xquery);
        }
        catch (ISRegistryException e) {
            throw new IndexServiceException((Throwable)e);
        }
    }

    @Required
    public void setRegistryLocator(ServiceLocator<ISRegistryService> registryLocator) {
        this.registryLocator = registryLocator;
    }

    public ServiceLocator<ISRegistryService> getRegistryLocator() {
        return this.registryLocator;
    }

    @Required
    public void setLookupLocator(ServiceLocator<ISLookUpService> lookupLocator) {
        this.lookupLocator = lookupLocator;
    }

    public ServiceLocator<ISLookUpService> getLookupLocator() {
        return this.lookupLocator;
    }

    @Required
    public void setServiceAddressGetter(ServiceAddressGetter serviceAddressGetter) {
        this.serviceAddressGetter = serviceAddressGetter;
    }

    public ServiceAddressGetter getServiceAddressGetter() {
        return this.serviceAddressGetter;
    }
}

