/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.functionality.index.solr.utils;

import eu.dnetlib.data.index.IndexServiceException;
import eu.dnetlib.functionality.index.solr.utils.MDFormatReader;
import eu.dnetlib.functionality.index.solr.utils.MetadataReference;
import eu.dnetlib.functionality.index.solr.utils.MetadataReferenceFactory;
import eu.dnetlib.functionality.index.solr.utils.ServiceTools;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Resource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class Weights
extends HashMap<MetadataReference, Map<String, String>> {
    private static final long serialVersionUID = -3517914310574484765L;
    private static final Log log = LogFactory.getLog(Weights.class);
    @Resource
    private ServiceTools serviceTools;
    @Resource
    private MetadataReferenceFactory mdFactory;
    @Resource
    private MDFormatReader mdFormatReader;

    public void initialize() throws IndexServiceException {
        log.info((Object)"initializing weights");
        for (String m : this.serviceTools.listMDRefs()) {
            MetadataReference mdRef = this.mdFactory.decodeMetadata(m);
            this.put(mdRef, this.mdFormatReader.getAttributeMap(mdRef, "weight"));
        }
        log.info((Object)"weights initialization completed");
    }

    @Override
    public Map<String, String> put(MetadataReference mdRef, Map<String, String> w) {
        log.info((Object)("[" + mdRef + "]" + " adding weights: " + w));
        return super.put(mdRef, w);
    }

    @Override
    public Map<String, String> get(Object mdRef) {
        Map<String, String> map = (Map<String, String>)super.get(mdRef);
        return map != null ? map : this.initAndGet(mdRef);
    }

    private Map<String, String> initAndGet(Object mdRef) {
        try {
            this.initialize();
        }
        catch (IndexServiceException e) {
            throw new RuntimeException(e);
        }
        return (Map)super.get(mdRef);
    }
}

