/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.functionality.index.solr;

import com.google.common.collect.Lists;
import eu.dnetlib.functionality.index.solr.SolrIndex;
import eu.dnetlib.functionality.index.solr.feed.IndexDocument;
import eu.dnetlib.functionality.index.solr.utils.IndexMap;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.Callable;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.solr.common.SolrDocument;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Node;
import org.dom4j.io.SAXReader;

public class IndexDocumentUpdater
implements Callable<Integer> {
    private static final Log log = LogFactory.getLog(IndexDocumentUpdater.class);
    private transient Integer nUpdates = 0;
    private transient Map<String, String> fieldXPath;
    private transient ArrayBlockingQueue<Object> queue;
    private transient Object sentinel;
    private String regex;
    private String replace;
    private SolrIndex index;
    private SAXReader saxReader = new SAXReader();

    public IndexDocumentUpdater(ArrayBlockingQueue<Object> queue, Object sentinel, Map<String, String> fieldXPath, SolrIndex index, String regex, String replace) {
        this.queue = queue;
        this.sentinel = sentinel;
        this.fieldXPath = fieldXPath;
        this.regex = regex;
        this.replace = replace;
        this.index = index;
    }

    @Override
    public Integer call() throws Exception {
        try {
            Object object;
            while (!(object = this.queue.take()).equals(this.sentinel)) {
                SolrDocument doc = (SolrDocument)object;
                IndexDocument newDoc = this.updateDocumentFields(this.fieldXPath, this.regex, this.replace, this.index, doc);
                newDoc.setField(IndexMap.RESULT, this.updateResultDoc(newDoc));
                this.index.add(newDoc);
            }
            return this.nUpdates;
        }
        catch (InterruptedException e) {
            log.error((Object)"error in update document thread", (Throwable)e);
            throw new RuntimeException(e);
        }
        catch (Exception e) {
            log.error((Object)"error in update document thread", (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    private IndexDocument updateDocumentFields(Map<String, String> fieldXPath, String regex, String replace, SolrIndex index, SolrDocument doc) {
        IndexDocument newDoc = new IndexDocument(index).setContent(doc);
        for (String fieldName : doc.getFieldNames()) {
            if (!(fieldXPath.containsKey(fieldName) | fieldXPath.isEmpty())) continue;
            Object values = doc.getFieldValuesMap().get(fieldName);
            if (values instanceof Collection) {
                ArrayList newValues = Lists.newArrayList();
                for (String value : (List)values) {
                    if (value.matches(regex)) {
                        newValues.add(value.replaceAll(regex, replace));
                        Integer n = this.nUpdates;
                        Integer n2 = this.nUpdates = Integer.valueOf(this.nUpdates + 1);
                        continue;
                    }
                    newValues.add(value);
                }
                newDoc.setField(fieldName, newValues);
                continue;
            }
            String value = (String)values;
            if (!value.matches(regex)) continue;
            newDoc.setField(fieldName, value.replaceAll(regex, replace));
            Integer n = this.nUpdates;
            Integer n3 = this.nUpdates = Integer.valueOf(this.nUpdates + 1);
        }
        return newDoc;
    }

    private String updateResultDoc(IndexDocument indexDocument) throws DocumentException {
        String resultXml = indexDocument.getFieldValue(IndexMap.RESULT).toString();
        Document resultDoc = this.saxReader.read((Reader)new StringReader(resultXml));
        for (Map.Entry<String, String> fieldEntry : this.fieldXPath.entrySet()) {
            List selectNodes = resultDoc.selectNodes(fieldEntry.getValue());
            for (Object o : selectNodes) {
                Node node = (Node)o;
                String value = node.getText().trim();
                node.setText(value.replaceAll(this.regex, this.replace));
            }
        }
        return resultDoc.asXML();
    }
}

