/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.functionality.index.solr;

import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import eu.dnetlib.data.index.IndexServiceException;
import eu.dnetlib.functionality.index.solr.utils.MetadataReference;
import eu.dnetlib.miscutils.collections.MappedCollection;
import eu.dnetlib.miscutils.functional.UnaryFunction;
import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.SimpleFSDirectory;
import org.apache.solr.client.solrj.SolrServer;
import org.apache.solr.client.solrj.embedded.EmbeddedSolrServer;
import org.apache.solr.core.CoreContainer;
import org.apache.solr.schema.IndexSchema;
import org.apache.solr.update.MergeIndexesCommand;
import org.xml.sax.SAXException;

public class LocalIndexServer {
    private static final Log log = LogFactory.getLog(LocalIndexServer.class);
    private transient CoreContainer container;
    private final transient SolrServer server;
    private final transient MetadataReference mdRef;
    private final transient Set<String> dsIds;
    private IndexSchema schema;

    public LocalIndexServer(MetadataReference mdRef, List<String> dsIds, String solrDataDir, IndexSchema schema) throws IndexServiceException {
        this.mdRef = mdRef;
        this.schema = schema;
        this.dsIds = Collections.synchronizedSet(Sets.newHashSet(dsIds));
        this.server = this.newEmbeddedSolrServer(solrDataDir);
    }

    private SolrServer newEmbeddedSolrServer(String solrDataDir) throws IndexServiceException {
        File home = new File(solrDataDir + '/' + this.mdRef.toString());
        this.container = new CoreContainer(home.getAbsolutePath());
        try {
            this.container.load(home.getAbsolutePath(), new File(home, "solr.xml"));
        }
        catch (ParserConfigurationException e) {
            throw new IndexServiceException((Throwable)e);
        }
        catch (IOException e) {
            throw new IndexServiceException((Throwable)e);
        }
        catch (SAXException e) {
            throw new IndexServiceException((Throwable)e);
        }
        return new EmbeddedSolrServer(this.container, this.mdRef.toString());
    }

    public void mergeIndexes(List<String> paths) throws IOException {
        log.info((Object)("merging PATHS: " + paths));
        this.container.getCore(this.mdRef.toString()).getUpdateHandler().mergeIndexes(new MergeIndexesCommand((IndexReader[])Iterables.toArray((Iterable)new MappedCollection(paths, (UnaryFunction)new UnaryFunction<IndexReader, String>(){

            public IndexReader evaluate(String path) {
                try {
                    return IndexReader.open((Directory)new SimpleFSDirectory(new File(path)), (boolean)true);
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
        }), IndexReader.class)));
        log.info((Object)"DONE merging DIRS");
    }

    public void restartCore() throws IndexServiceException {
        log.info((Object)("restarting core: " + this.mdRef.toString()));
        try {
            this.getContainer().reload(this.mdRef.toString());
        }
        catch (ParserConfigurationException e) {
            throw new IndexServiceException((Throwable)e);
        }
        catch (IOException e) {
            throw new IndexServiceException((Throwable)e);
        }
        catch (SAXException e) {
            throw new IndexServiceException((Throwable)e);
        }
    }

    public SolrServer getServer() {
        return this.server;
    }

    public IndexSchema getSchema() {
        return this.schema;
    }

    public void setSchema(IndexSchema schema) {
        this.schema = schema;
    }

    public Set<String> getDsIds() {
        return this.dsIds;
    }

    public CoreContainer getContainer() {
        return this.container;
    }
}

