/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.functionality.index.solr;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.base.Splitter;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import eu.dnetlib.common.ws.dataprov.DataProviderException;
import eu.dnetlib.common.ws.dataprov.ResultsResponse;
import eu.dnetlib.data.index.IIndexService;
import eu.dnetlib.data.index.IndexServiceException;
import eu.dnetlib.enabling.is.lookup.rmi.ISLookUpDocumentNotFoundException;
import eu.dnetlib.enabling.is.lookup.rmi.ISLookUpException;
import eu.dnetlib.enabling.is.lookup.rmi.ISLookUpService;
import eu.dnetlib.enabling.resultset.client.ResultSetClientFactory;
import eu.dnetlib.enabling.tools.blackboard.BlackboardJob;
import eu.dnetlib.functionality.index.solr.SolrIndexNotificationHandler;
import eu.dnetlib.functionality.index.solr.SolrIndexServer;
import eu.dnetlib.functionality.index.solr.actors.BlackboardActorCallback;
import eu.dnetlib.functionality.index.solr.actors.IndexServerActor;
import eu.dnetlib.functionality.index.solr.actors.IndexServerActorFactory;
import eu.dnetlib.functionality.index.solr.actors.ResultsetKeepAliveCallback;
import eu.dnetlib.functionality.index.solr.feed.FeedMode;
import eu.dnetlib.functionality.index.solr.feed.FileType;
import eu.dnetlib.functionality.index.solr.query.IndexQueryFactory;
import eu.dnetlib.functionality.index.solr.query.QueryLanguage;
import eu.dnetlib.functionality.index.solr.resultset.factory.IndexResultSetFactory;
import eu.dnetlib.functionality.index.solr.rmi.SolrIndexRmi;
import eu.dnetlib.functionality.index.solr.rmi.SolrIndexRmiEprHandler;
import eu.dnetlib.functionality.index.solr.suggest.Hint;
import eu.dnetlib.functionality.index.solr.suggest.SuggestionApi;
import eu.dnetlib.functionality.index.solr.utils.IndexMap;
import eu.dnetlib.functionality.index.solr.utils.MDFormatReader;
import eu.dnetlib.functionality.index.solr.utils.MetadataReference;
import eu.dnetlib.functionality.index.solr.utils.MetadataReferenceFactory;
import eu.dnetlib.functionality.index.solr.utils.ServiceTools;
import eu.dnetlib.miscutils.collections.MappedCollection;
import eu.dnetlib.miscutils.collections.Pair;
import eu.dnetlib.miscutils.datetime.HumanTime;
import eu.dnetlib.miscutils.functional.UnaryFunction;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Resource;
import javax.xml.ws.wsaddressing.W3CEndpointReference;
import org.antlr.stringtemplate.StringTemplate;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Required;
import org.springframework.util.StringUtils;

public class SolrIndexServiceImpl
implements IIndexService,
SolrIndexRmi,
SuggestionApi {
    private static final Log log = LogFactory.getLog(SolrIndexServiceImpl.class);
    private transient SolrIndexNotificationHandler notificationHandler;
    private transient StringTemplate indexDsTemplate;
    private transient IndexResultSetFactory indexResultSetFactory;
    private SolrIndexRmiEprHandler rmiEprHandler;
    private transient ResultSetClientFactory rsClientFactory;
    private SolrIndexServer solrIndexServer;
    private IndexServerActorFactory actorFactory;
    private transient Map<MetadataReference, IndexServerActor> actorMap;
    private transient ServiceTools serviceTools;
    private MetadataReferenceFactory mdFactory;
    private int rsClientPageSize;
    @Resource
    private transient MDFormatReader mdFormatReader;

    public void init() {
        this.actorMap = new ConcurrentHashMap<MetadataReference, IndexServerActor>();
    }

    public String createIndex(BlackboardJob job, BlackboardActorCallback callback) throws IndexServiceException {
        MetadataReference mdRef = this.getMetadataRef(job);
        if (mdRef.getFormat() == null || mdRef.getLayout() == null) {
            throw new IndexServiceException("some Blackboard parameter is missing in CREATE message");
        }
        String fields = this.serviceTools.getIndexFields(mdRef);
        if (fields.isEmpty()) {
            throw new IndexServiceException("No result getting index layout informations");
        }
        String dataStructure = this.getDataStructure(mdRef);
        log.info((Object)("IndexDataStructure:\n" + dataStructure));
        String dsId = this.serviceTools.registerProfile(dataStructure);
        this.getActor(mdRef).createIndex(dsId, mdRef, fields, callback);
        return dsId;
    }

    public void feedIndex(BlackboardJob job, ResultsetKeepAliveCallback startCallback, BlackboardActorCallback endCallback) throws IndexServiceException {
        String dsId = (String)job.getParameters().get("id");
        String localURI = (String)job.getParameters().get("local_URI");
        FeedMode feedMode = FeedMode.valueOf((String)job.getParameters().get("feeding_type"));
        String rsEpr = this.decodeBase64((String)job.getParameters().get("resultset_epr"));
        log.debug((Object)("\nEPR:\n" + rsEpr + "\n\n"));
        if (dsId == null || feedMode == null || rsEpr == null) {
            throw new IndexServiceException("some Blackboard parameter is missing in FEED message");
        }
        if (localURI != null) {
            rsEpr = this.indexResultSetFactory.getFileSystemResultSet(FileType.TEXT, localURI).toString();
        }
        log.info((Object)("\n\n - FEEDING dsId: " + dsId + " in " + feedMode.toString() + " mode"));
        MetadataReference mdRef = this.serviceTools.getMetadataRef(dsId);
        this.getActor(mdRef).feedIndex(dsId, feedMode, this.rsClientFactory.getClient(rsEpr, this.getRsClientPageSize()), startCallback, endCallback);
    }

    public int updateDocuments(String query, MetadataReference mdRef, String fieldList, String regex, String replacement) throws IndexServiceException {
        ArrayList fields = Lists.newArrayList((Iterable)Splitter.on((String)",").trimResults().split((CharSequence)fieldList));
        Predicate predicate = fields.isEmpty() ? Predicates.alwaysTrue() : Predicates.in((Collection)fields);
        Map fieldsMap = Maps.filterKeys(this.mdFormatReader.getAttributeMap(mdRef, "xpath"), (Predicate)predicate);
        return this.getActor(mdRef).updateDocuments(query, mdRef, fieldsMap, regex, replacement);
    }

    public void deleteIndex(BlackboardJob job, BlackboardActorCallback callback) throws IndexServiceException {
        String dsId = (String)job.getParameters().get("id");
        String query = (String)job.getParameters().get("query");
        if (dsId == null) {
            throw new IndexServiceException("some Blackboard parameter is missing in DELETE message");
        }
        if (query == null || query.length() == 0) {
            query = "textual";
        }
        if (dsId.equals(IndexMap.INDEX_DSID_ALL)) {
            MetadataReference mdRef = this.getMetadataRef(job);
            if (mdRef.getFormat() == null || mdRef.getLayout() == null) {
                throw new IndexServiceException("some Blackboard parameter is missing in DELETE message");
            }
            dsId = this.serviceTools.getIndexDsIdsList(mdRef).get(0);
        }
        log.info((Object)("\n\n - DELETE BY QUERY >>>>>>> query: " + query + " dsId: " + dsId));
        this.getActor(this.serviceTools.getMetadataRef(dsId)).deleteByQuery(query, dsId, callback);
        if (!this.serviceTools.deleteIndexDS(dsId)) {
            log.warn((Object)("couldn't delete IndexDS: " + dsId));
        }
        log.info((Object)("\n\nDELETE report:\n- dsId: " + dsId + "\n- query: " + query));
    }

    public void mergeIndex(BlackboardJob job, BlackboardActorCallback callback) throws ISLookUpException, IOException {
        MetadataReference mdRef = this.getMetadataRef(job);
        if (mdRef.getFormat() == null || mdRef.getLayout() == null) {
            throw new ISLookUpException("some Blackboard parameter is missing in TRANSFORM message");
        }
        this.getActor(mdRef).mergeIndexes(mdRef, MappedCollection.listMap(this.decodeJsonList((String)job.getParameters().get("index_epr")), (UnaryFunction)new UnaryFunction<W3CEndpointReference, String>(){

            public W3CEndpointReference evaluate(String epr) {
                return SolrIndexServiceImpl.this.rmiEprHandler.hackEpr(epr);
            }
        }), callback);
    }

    @Override
    public List<String> getIndexFiles(String format, String layout, String interpretation) {
        MetadataReference mdRef = this.mdFactory.getMetadata(format, layout, interpretation);
        return this.getActor(mdRef).getIndexFiles(mdRef);
    }

    @Override
    public Hint suggestAlternateTerm(String dsId, String mdFormat, String layout, String interpretation, String heuristicProfileName, String term) {
        try {
            Pair<String, Hint> suggest = this.solrIndexServer.suggest(QueryLanguage.CQL, term, this.mdFactory.getMetadata(mdFormat, layout, interpretation), dsId);
            return (Hint)suggest.getValue();
        }
        catch (IndexServiceException e) {
            log.error((Object)e);
            throw new RuntimeException(e);
        }
    }

    public W3CEndpointReference indexLookup(String dsId, String query, String mdFormatId, String layoutId) throws IndexServiceException {
        log.debug((Object)("got lookup request, index: " + dsId + ", query: " + query));
        try {
            MetadataReference mdRef = this.mdFactory.getMetadata(mdFormatId, layoutId);
            long start = System.currentTimeMillis();
            W3CEndpointReference epr = this.indexResultSetFactory.getLookupResultSet(QueryLanguage.CQL, query, mdRef, this.parseDsId(dsId));
            if (log.isDebugEnabled()) {
                log.debug((Object)("indexLookup time: " + HumanTime.exactly((long)(System.currentTimeMillis() - start))));
            }
            return epr;
        }
        catch (Throwable e) {
            log.error((Object)"indexLookup error", e);
            throw new IndexServiceException(e);
        }
    }

    public W3CEndpointReference getBrowsingStatistics(String query, String dsId, String mdFormatId, String layoutId) throws IndexServiceException {
        log.debug((Object)("got browse request, index: " + dsId + ", query: " + query));
        try {
            MetadataReference mdRef = this.mdFactory.getMetadata(mdFormatId, layoutId);
            long start = System.currentTimeMillis();
            W3CEndpointReference epr = this.indexResultSetFactory.getBrowsingResultSet(QueryLanguage.CQL, query, mdRef, this.parseDsId(dsId));
            if (log.isDebugEnabled()) {
                log.debug((Object)("getBrowsingStatistics time: " + HumanTime.exactly((long)(System.currentTimeMillis() - start))));
            }
            return epr;
        }
        catch (Throwable e) {
            log.error((Object)"getBrowsingStatistics error", e);
            throw new IndexServiceException(e);
        }
    }

    public String getIndexStatistics(String ixId) throws IndexServiceException {
        try {
            return ((ISLookUpService)this.serviceTools.getLookupLocator().getService()).getResourceProfile(ixId);
        }
        catch (ISLookUpDocumentNotFoundException e) {
            String errorContent = "Exception occured when geting index statistics from IS. Profile identified by" + ixId + " not found in IS Registry.";
            log.error((Object)errorContent, (Throwable)e);
            throw new IndexServiceException(errorContent, (Throwable)e);
        }
        catch (ISLookUpException e) {
            throw new IndexServiceException("Exception occured when getting index statistics from IS!; nested error message: " + e.getMessage(), (Throwable)e);
        }
    }

    public String[] getListOfIndices() {
        return this.solrIndexServer.getIndexList();
    }

    public String getListOfIndicesCSV() {
        return this.solrIndexServer.getIndexListCSV();
    }

    public ResultsResponse getNumberOfResults(String bdId) throws DataProviderException {
        try {
            return this.solrIndexServer.getNumberOfRecords(bdId);
        }
        catch (Exception e) {
            log.error((Object)("getNumberOfResults: " + bdId), (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public String identify() {
        return this.getClass().getName();
    }

    public boolean notify(String subscrId, String topic, String isId, String message) {
        log.info((Object)"---- service got notification ----");
        log.info((Object)("subscrId: " + subscrId));
        log.info((Object)("topic " + topic));
        log.info((Object)("isId " + isId));
        log.debug((Object)("msg: " + message));
        log.info((Object)"____ now processing the notification ____");
        this.notificationHandler.notified(subscrId, topic, isId, message);
        return true;
    }

    public String[] getSimpleBulkData(String bdId, int fromPosition, int toPosition) throws DataProviderException {
        throw new DataProviderException("Not implemented");
    }

    public List<String> getBulkData(String bdId, int fromPosition, int toPosition) throws DataProviderException {
        throw new DataProviderException("Not implemented");
    }

    public IndexServerActor getActor(MetadataReference mdRef) {
        if (this.actorMap.get(mdRef) == null) {
            this.actorMap.put(mdRef, this.actorFactory.newInstance());
        }
        return this.actorMap.get(mdRef);
    }

    public IndexServerActor getActor(String dsId) {
        return this.getActor(this.solrIndexServer.getIndexMap().getMdRefById(dsId));
    }

    private String[] parseDsId(String dsId) {
        String[] dsIds = StringUtils.delimitedListToStringArray((String)(dsId = dsId.replace(" ", "").replace("\t", "").replace("\n", "")), (String)IndexQueryFactory.INDEX_DELIMITER);
        if (dsIds.length == 0) {
            throw new IllegalArgumentException("Invalid ixId parameter: " + dsId);
        }
        if (dsIds.length == 1 && dsIds[0].toUpperCase().equals(IndexMap.INDEX_DSID_ALL)) {
            dsIds[0] = IndexMap.INDEX_DSID_ALL;
        }
        return dsIds;
    }

    private List<String> decodeJsonList(String json) {
        return (List)new Gson().fromJson(json, new TypeToken<List<String>>(){}.getType());
    }

    private String decodeBase64(String encoded) {
        if (encoded != null && Base64.isArrayByteBase64((byte[])encoded.getBytes())) {
            return new String(Base64.decodeBase64((byte[])encoded.getBytes()));
        }
        return encoded;
    }

    private String getDataStructure(MetadataReference mdRef) {
        StringTemplate ds = new StringTemplate(this.indexDsTemplate.getTemplate());
        ds.setAttribute("serviceUri", (Object)this.serviceTools.getServiceAddress());
        ds.setAttribute("format", (Object)mdRef.getFormat());
        ds.setAttribute("layout", (Object)mdRef.getLayout());
        ds.setAttribute("interpretation", (Object)mdRef.getInterpretation());
        return ds.toString();
    }

    private MetadataReference getMetadataRef(BlackboardJob job) {
        return this.mdFactory.getMetadata((String)job.getParameters().get("format"), (String)job.getParameters().get("layout"), (String)job.getParameters().get("interpretation"));
    }

    @Required
    public void setNotificationHandler(SolrIndexNotificationHandler notificationHandler) {
        this.notificationHandler = notificationHandler;
    }

    @Required
    public void setSolrIndexServer(SolrIndexServer solrIndexServer) {
        this.solrIndexServer = solrIndexServer;
    }

    public SolrIndexServer getSolrIndexServer() {
        return this.solrIndexServer;
    }

    @Required
    public void setIndexDsTemplate(StringTemplate indexDsTemplate) {
        this.indexDsTemplate = indexDsTemplate;
    }

    @Required
    public void setRsClientFactory(ResultSetClientFactory rsClientFactory) {
        this.rsClientFactory = rsClientFactory;
    }

    @Required
    public void setIndexResultSetFactory(IndexResultSetFactory indexResultSetFactory) {
        this.indexResultSetFactory = indexResultSetFactory;
    }

    @Required
    public void setServiceTools(ServiceTools serviceTools) {
        this.serviceTools = serviceTools;
    }

    @Required
    public void setMdFactory(MetadataReferenceFactory mdFactory) {
        this.mdFactory = mdFactory;
    }

    public MetadataReferenceFactory getMdFactory() {
        return this.mdFactory;
    }

    @Required
    public void setActorFactory(IndexServerActorFactory actorFactory) {
        this.actorFactory = actorFactory;
    }

    public IndexServerActorFactory getActorFactory() {
        return this.actorFactory;
    }

    @Required
    public void setRmiEprHandler(SolrIndexRmiEprHandler rmiEprHandler) {
        this.rmiEprHandler = rmiEprHandler;
    }

    public SolrIndexRmiEprHandler getRmiEprHandler() {
        return this.rmiEprHandler;
    }

    @Required
    public void setRsClientPageSize(int rsClientPageSize) {
        this.rsClientPageSize = rsClientPageSize;
    }

    public int getRsClientPageSize() {
        return this.rsClientPageSize;
    }
}

