/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.functionality.index.solr.component;

import eu.dnetlib.functionality.index.solr.component.ComponentBean;
import eu.dnetlib.functionality.index.solr.component.ComponentBeanChannel;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.lucene.index.Term;
import org.apache.lucene.queryParser.ParseException;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.grouping.SearchGroup;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.common.util.StrUtils;
import org.apache.solr.handler.component.QueryComponent;
import org.apache.solr.handler.component.ResponseBuilder;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.response.SolrQueryResponse;
import org.apache.solr.schema.SchemaField;
import org.apache.solr.search.DocListAndSet;
import org.apache.solr.search.DocSlice;
import org.apache.solr.search.Grouping;
import org.apache.solr.search.SolrIndexSearcher;
import org.apache.solr.search.grouping.Command;
import org.apache.solr.search.grouping.CommandHandler;
import org.apache.solr.search.grouping.GroupingSpecification;
import org.apache.solr.search.grouping.distributed.command.QueryCommand;
import org.apache.solr.search.grouping.distributed.command.SearchGroupsFieldCommand;
import org.apache.solr.search.grouping.distributed.command.TopGroupsFieldCommand;
import org.apache.solr.search.grouping.distributed.shardresultserializer.SearchGroupsResultTransformer;
import org.apache.solr.search.grouping.distributed.shardresultserializer.ShardResultTransformer;
import org.apache.solr.search.grouping.distributed.shardresultserializer.TopGroupsResultTransformer;

public class DynamicSearchComponent
extends QueryComponent {
    public void process(ResponseBuilder rb) throws IOException {
        SolrQueryRequest req = rb.req;
        SolrQueryResponse rsp = rb.rsp;
        SolrParams params = req.getParams();
        if (!params.getBool("query", true)) {
            return;
        }
        SolrIndexSearcher searcher = req.getSearcher();
        if (rb.getQueryCommand().getOffset() < 0) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "'start' parameter cannot be negative");
        }
        long timeAllowed = params.getInt("timeAllowed", -1);
        String ids = params.get("ids");
        if (ids != null) {
            SchemaField idField = req.getSchema().getUniqueKeyField();
            List idArr = StrUtils.splitSmart((String)ids, (String)",", (boolean)true);
            int[] luceneIds = new int[idArr.size()];
            int docs = 0;
            for (int i = 0; i < idArr.size(); ++i) {
                int id = req.getSearcher().getFirstMatch(new Term(idField.getName(), idField.getType().toInternal((String)idArr.get(i))));
                if (id < 0) continue;
                luceneIds[docs++] = id;
            }
            DocListAndSet res = new DocListAndSet();
            res.docList = new DocSlice(0, docs, luceneIds, null, docs, 0.0f);
            if (rb.isNeedDocSet()) {
                ArrayList<Query> queries = new ArrayList<Query>();
                queries.add(rb.getQuery());
                List filters = rb.getFilters();
                if (filters != null) {
                    queries.addAll(filters);
                }
                res.docSet = searcher.getDocSet(queries);
            }
            rb.setResults(res);
            rsp.add("response", (Object)rb.getResults().docList);
            return;
        }
        SolrIndexSearcher.QueryCommand cmd = rb.getQueryCommand();
        cmd.setTimeAllowed(timeAllowed);
        SolrIndexSearcher.QueryResult result = new SolrIndexSearcher.QueryResult();
        GroupingSpecification groupingSpec = rb.getGroupingSpec();
        if (groupingSpec != null) {
            try {
                boolean needScores;
                boolean bl = needScores = (cmd.getFlags() & 1) != 0;
                if (params.getBool("group.distibuted.first", false)) {
                    CommandHandler.Builder topsGroupsActionBuilder = new CommandHandler.Builder().setQueryCommand(cmd).setNeedDocSet(false).setSearcher(searcher);
                    for (String field : groupingSpec.getFields()) {
                        topsGroupsActionBuilder.addCommandField((Command)new SearchGroupsFieldCommand.Builder().setField(searcher.getSchema().getField(field)).setGroupSort(groupingSpec.getGroupSort()).setTopNGroups(cmd.getOffset() + cmd.getLen()).build());
                    }
                    CommandHandler commandHandler = topsGroupsActionBuilder.build();
                    commandHandler.execute();
                    SearchGroupsResultTransformer serializer = new SearchGroupsResultTransformer(searcher);
                    rsp.add("firstPhase", (Object)commandHandler.processResult(result, (ShardResultTransformer)serializer));
                    rb.setResult(result);
                    return;
                }
                if (params.getBool("group.distibuted.second", false)) {
                    CommandHandler.Builder secondPhaseBuilder = new CommandHandler.Builder().setQueryCommand(cmd).setTruncateGroups(groupingSpec.isTruncateGroups() && groupingSpec.getFields().length > 0).setSearcher(searcher);
                    for (String field : groupingSpec.getFields()) {
                        String[] topGroupsParam = params.getParams("group.topgroups." + field);
                        if (topGroupsParam == null) continue;
                        ArrayList<SearchGroup> topGroups = new ArrayList<SearchGroup>(topGroupsParam.length);
                        for (String topGroup : topGroupsParam) {
                            SearchGroup searchGroup = new SearchGroup();
                            if (!topGroup.equals("\u0001")) {
                                searchGroup.groupValue = searcher.getSchema().getField(field).getType().readableToIndexed(topGroup);
                            }
                            topGroups.add(searchGroup);
                        }
                        secondPhaseBuilder.addCommandField((Command)new TopGroupsFieldCommand.Builder().setField(searcher.getSchema().getField(field)).setGroupSort(groupingSpec.getGroupSort()).setSortWithinGroup(groupingSpec.getSortWithinGroup()).setFirstPhaseGroups(topGroups).setMaxDocPerGroup(groupingSpec.getGroupOffset() + groupingSpec.getGroupLimit()).setNeedScores(Boolean.valueOf(needScores)).setNeedMaxScore(Boolean.valueOf(needScores)).setNeedGroupCount(Boolean.valueOf(groupingSpec.isIncludeGroupCount())).build());
                    }
                    for (String query : groupingSpec.getQueries()) {
                        secondPhaseBuilder.addCommandField((Command)new QueryCommand.Builder().setDocsToCollect(groupingSpec.getOffset() + groupingSpec.getLimit()).setSort(groupingSpec.getGroupSort()).setQuery(query, rb.req).setDocSet(searcher).build());
                    }
                    CommandHandler commandHandler = secondPhaseBuilder.build();
                    commandHandler.execute();
                    TopGroupsResultTransformer serializer = new TopGroupsResultTransformer(rb);
                    rsp.add("secondPhase", (Object)commandHandler.processResult(result, (ShardResultTransformer)serializer));
                    rb.setResult(result);
                    return;
                }
                int maxDocsPercentageToCache = params.getInt("group.cache.percent", 0);
                boolean cacheSecondPassSearch = maxDocsPercentageToCache >= 1 && maxDocsPercentageToCache <= 100;
                Grouping.TotalCount defaultTotalCount = groupingSpec.isIncludeGroupCount() ? Grouping.TotalCount.grouped : Grouping.TotalCount.ungrouped;
                int limitDefault = cmd.getLen();
                Grouping grouping = new Grouping(searcher, result, cmd, cacheSecondPassSearch, maxDocsPercentageToCache, groupingSpec.isMain());
                grouping.setSort(groupingSpec.getGroupSort()).setGroupSort(groupingSpec.getSortWithinGroup()).setDefaultFormat(groupingSpec.getResponseFormat()).setLimitDefault(limitDefault).setDefaultTotalCount(defaultTotalCount).setDocsPerGroupDefault(groupingSpec.getGroupLimit()).setGroupOffsetDefault(groupingSpec.getGroupOffset()).setGetGroupedDocSet(groupingSpec.isTruncateGroups());
                if (groupingSpec.getFields() != null) {
                    for (String field : groupingSpec.getFields()) {
                        grouping.addFieldCommand(field, rb.req);
                    }
                }
                if (groupingSpec.getQueries() != null) {
                    for (String groupByStr : groupingSpec.getQueries()) {
                        grouping.addQueryCommand(groupByStr, rb.req);
                    }
                }
                if (rb.doHighlights || rb.isDebug() || params.getBool("mlt", false)) {
                    cmd.setFlags(2);
                }
                grouping.execute();
                if (grouping.isSignalCacheWarning()) {
                    rsp.add("cacheWarning", (Object)String.format("Cache limit of %d percent relative to maxdoc has exceeded. Please increase cache size or disable caching.", maxDocsPercentageToCache));
                }
                rb.setResult(result);
                if (grouping.mainResult != null) {
                    rsp.add("response", (Object)grouping.mainResult);
                    rsp.getToLog().add("hits", (Object)grouping.mainResult.matches());
                } else if (!grouping.getCommands().isEmpty()) {
                    rsp.add("grouped", result.groupedResults);
                    rsp.getToLog().add("hits", (Object)((Grouping.Command)grouping.getCommands().get(0)).getMatches());
                }
                return;
            }
            catch (ParseException e) {
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, (Throwable)e);
            }
        }
        ComponentBean bean = ComponentBeanChannel.getBean();
        if (bean != null) {
            bean.handleRequest(searcher, cmd, result);
        } else {
            searcher.search(result, cmd);
        }
        rb.setResult(result);
        rsp.add("response", (Object)rb.getResults().docList);
        rsp.getToLog().add("hits", (Object)rb.getResults().docList.matches());
        this.doFieldSortValues(rb, searcher);
        this.doPrefetch(rb);
    }
}

