/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.functionality.index.solr.direct;

import com.google.gson.Gson;
import eu.dnetlib.functionality.index.solr.direct.DirectIndexService;
import eu.dnetlib.functionality.index.solr.direct.ZmqRequest;
import eu.dnetlib.miscutils.datetime.HumanTime;
import java.util.Map;
import javax.annotation.PostConstruct;
import javax.annotation.Resource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Required;
import org.zeromq.ZMQ;

public class ZmqIndexService {
    private static final Log log = LogFactory.getLog(ZmqIndexService.class);
    private ZMQ.Context context;
    private int nWorker = 24;
    @Resource
    private DirectIndexService directService;

    @PostConstruct
    public void init() throws InterruptedException {
        log.info((Object)("ZZZZZZZZZZZZ starting ZMQ: " + this.context));
        if (this.context != null) {
            for (int i = 0; i < this.getnWorker(); ++i) {
                this.startWorker(i);
            }
        }
    }

    private void startWorker(final int w) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                log.info((Object)"ZMQ worker ready!!!!");
                try {
                    while (true) {
                        try {
                            ZmqIndexService.this.worker(w);
                        }
                        catch (Throwable e) {
                            log.fatal((Object)"failed ZMQ worker", e);
                        }
                        Thread.sleep(2000L);
                        log.fatal((Object)"restarting failed ZMQ worker");
                    }
                }
                catch (InterruptedException e) {
                    log.fatal((Object)"cannot restart failed ZMQ worker", (Throwable)e);
                    return;
                }
            }
        }).start();
    }

    private void worker(int w) throws InterruptedException {
        ZMQ.Socket socket = this.context.socket(4);
        try {
            for (int i = 0; i < 16; ++i) {
                socket.connect(String.format("tcp://localhost:64%02d", i));
            }
            Gson gson = new Gson();
            while (true) {
                byte[] data = socket.recv(0);
                byte[] response = null;
                try {
                    ZmqRequest request = (ZmqRequest)gson.fromJson(new String(data), ZmqRequest.class);
                    long dispatchStart = System.currentTimeMillis();
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("request = " + request));
                    }
                    response = this.dispatch(request);
                    if (log.isDebugEnabled()) {
                        this.logRequest(request, dispatchStart);
                    }
                }
                catch (Throwable e) {
                    response = ("Unknown error: " + e.getMessage()).getBytes();
                }
                long sendStart = System.currentTimeMillis();
                if (log.isDebugEnabled()) {
                    log.debug((Object)"sending response");
                }
                socket.send(response, 0);
                if (!log.isDebugEnabled()) continue;
                log.debug((Object)("sent ZMQ response in: " + (System.currentTimeMillis() - sendStart) + " ms \n"));
            }
        }
        catch (Throwable throwable) {
            log.fatal((Object)"closing ZMQ socket!");
            socket.close();
            throw throwable;
        }
    }

    private void logRequest(ZmqRequest request, long dispatchStart) {
        long dispatchDelta = System.currentTimeMillis() - dispatchStart;
        String msg = "dispatched ZMQ request in: " + HumanTime.exactly((long)dispatchDelta) + "\n" + "request = " + request;
        if (dispatchDelta > 5000L) {
            msg = "\n-------------------------------\n" + msg + "\n-------------------------------\n";
        }
        log.debug((Object)msg);
    }

    private byte[] dispatch(ZmqRequest request) {
        String method = request.getMethod();
        Map<String, String> p = request.getParams();
        if ("indexLookup".equals(method)) {
            return this.directService.indexLookup(p.get("id"), p.get("query"), p.get("mdformat"), p.get("layout")).getBytes();
        }
        if ("getNumberOfElements".equals(method)) {
            return this.directService.getNumberOfElements(p.get("rsId")).getBytes();
        }
        if ("getResult".equals(method)) {
            return this.directService.getResult(p.get("rsId"), Integer.parseInt(p.get("fromPosition")), Integer.parseInt(p.get("toPosition"))).getBytes();
        }
        if ("getBrowsingStatistics".equals(method)) {
            return this.directService.getBrowsingStatistics(p.get("query"), p.get("index"), p.get("mdformat"), p.get("layout")).getBytes();
        }
        if ("inlineIndexLookup".equals(method)) {
            return this.directService.inlineIndexLookup(p.get("id"), p.get("query"), p.get("mdformat"), p.get("layout"), Integer.parseInt(p.get("fromPosition")), Integer.parseInt(p.get("toPosition"))).getBytes();
        }
        return ("unknown method " + method).getBytes();
    }

    public ZMQ.Context getContext() {
        return this.context;
    }

    @Required
    public void setContext(ZMQ.Context context) {
        this.context = context;
    }

    public int getnWorker() {
        return this.nWorker;
    }

    public void setnWorker(int nWorker) {
        this.nWorker = nWorker;
    }
}

