/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.functionality.index.solr.feed;

import com.google.common.base.Function;
import com.google.common.collect.Iterables;
import eu.dnetlib.functionality.index.solr.SolrIndex;
import eu.dnetlib.functionality.index.solr.feed.IndexDocument;
import eu.dnetlib.functionality.index.solr.feed.IndexDocumentCallback;
import eu.dnetlib.functionality.index.solr.feed.InputDocumentFactory;
import eu.dnetlib.functionality.index.solr.query.IndexQuery;
import eu.dnetlib.functionality.index.solr.utils.IndexMap;
import java.text.ParseException;
import java.util.NoSuchElementException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.solr.common.SolrDocument;
import org.apache.solr.common.params.SolrParams;
import org.dom4j.DocumentException;
import org.springframework.beans.factory.annotation.Required;

public class DocumentMapperFactory {
    private static final Log log = LogFactory.getLog(DocumentMapperFactory.class);
    private InputDocumentFactory documentFactory;

    public Function<String, IndexDocument> getMetatadaMapper(final SolrIndex index, final String version) {
        return new Function<String, IndexDocument>(){

            public IndexDocument apply(String doc) {
                return DocumentMapperFactory.this.getInputDocument(index, version, doc);
            }
        };
    }

    public Function<String, String> getDateMapper() {
        return new Function<String, String>(){

            public String apply(String date) {
                try {
                    return DocumentMapperFactory.this.documentFactory.getParsedDateField(date);
                }
                catch (ParseException e) {
                    log.error((Object)("error parsing date value: " + date), (Throwable)e);
                    throw new IllegalArgumentException(e);
                }
            }
        };
    }

    public Function<String, IndexDocument> getUpdateMapper(final SolrIndex index) {
        return new Function<String, IndexDocument>(){

            public IndexDocument apply(String doc) {
                IndexDocument document = DocumentMapperFactory.this.getUpdateDocument(index, doc);
                if (document.getStatus().equals((Object)IndexDocument.STATUS.OK)) {
                    String recordId = (String)document.getFieldValue(IndexMap.INDEX_RECORD_ID);
                    SolrDocument solrDocument = DocumentMapperFactory.this.getSingleDocument(index, recordId);
                    if (solrDocument != null) {
                        solrDocument.addField(IndexMap.FULLTEXT_ID, document.getFieldValue(IndexMap.FULLTEXT_ID));
                        document.setContent(solrDocument);
                    } else {
                        document.setError(new IllegalStateException("document id not found"));
                    }
                }
                return document;
            }
        };
    }

    private SolrDocument getSingleDocument(SolrIndex index, String recordId) {
        try {
            IndexQuery indexQuery = new IndexQuery(IndexMap.INDEX_RECORD_ID + ":\"" + recordId + "\"");
            return (SolrDocument)Iterables.getOnlyElement((Iterable)index.getServer().query((SolrParams)indexQuery).getResults());
        }
        catch (NoSuchElementException e) {
            log.warn((Object)("cannot find record with id: " + recordId));
            return null;
        }
        catch (Exception e) {
            throw new RuntimeException("cannot fetch single document: " + recordId, e);
        }
    }

    private IndexDocument getInputDocument(SolrIndex index, String version, String doc) {
        try {
            return this.documentFactory.getInputDocument(this.getNewDocumentCallback(index), version, doc);
        }
        catch (DocumentException e) {
            return new IndexDocument(index).setError(e);
        }
    }

    private IndexDocumentCallback getNewDocumentCallback(final SolrIndex index) {
        return new IndexDocumentCallback(){

            @Override
            public IndexDocument get(String recordId) {
                return new IndexDocument(index);
            }
        };
    }

    private IndexDocument getUpdateDocument(SolrIndex index, String doc) {
        try {
            return this.documentFactory.getInputDocument(this.getSingleDocumentCallback(index), null, doc);
        }
        catch (DocumentException e) {
            return new IndexDocument(index).setError(e);
        }
    }

    private IndexDocumentCallback getSingleDocumentCallback(final SolrIndex index) {
        return new IndexDocumentCallback(){

            @Override
            public IndexDocument get(String recordId) {
                return new IndexDocument(index).setContent(DocumentMapperFactory.this.getSingleDocument(index, recordId));
            }
        };
    }

    public InputDocumentFactory getDocumentFactory() {
        return this.documentFactory;
    }

    @Required
    public void setDocumentFactory(InputDocumentFactory documentFactory) {
        this.documentFactory = documentFactory;
    }
}

