/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.functionality.index.solr.feed;

import com.google.common.collect.Lists;
import eu.dnetlib.functionality.index.solr.feed.IndexDocument;
import eu.dnetlib.functionality.index.solr.feed.IndexDocumentCallback;
import eu.dnetlib.functionality.index.solr.feed.InputDocumentFactory;
import eu.dnetlib.functionality.index.solr.utils.IndexMap;
import java.io.StringReader;
import java.io.StringWriter;
import java.text.ParseException;
import java.util.ArrayList;
import javax.xml.stream.XMLEventFactory;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLEventWriter;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.Namespace;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dom4j.DocumentException;

public class StreamingInputDocumentFactory
extends InputDocumentFactory {
    private static final Log log = LogFactory.getLog(StreamingInputDocumentFactory.class);
    protected static final String RESULTFIELD = "result";
    protected static final String TARGETFIELDS = "targetFields";
    protected static final String INDEX_RECORD_ID = "indexRecordIdentifier";
    ThreadLocal<XMLInputFactory> inputFactory = new ThreadLocal<XMLInputFactory>(){

        @Override
        protected XMLInputFactory initialValue() {
            return XMLInputFactory.newInstance();
        }
    };
    ThreadLocal<XMLOutputFactory> outputFactory = new ThreadLocal<XMLOutputFactory>(){

        @Override
        protected XMLOutputFactory initialValue() {
            return XMLOutputFactory.newInstance();
        }
    };
    ThreadLocal<XMLEventFactory> eventFactory = new ThreadLocal<XMLEventFactory>(){

        @Override
        protected XMLEventFactory initialValue() {
            return XMLEventFactory.newInstance();
        }
    };

    @Override
    protected IndexDocument parseDocument(IndexDocumentCallback callback, String version, String inputDocument) throws DocumentException {
        try {
            StringWriter results = new StringWriter();
            XMLEventReader parser = this.inputFactory.get().createXMLEventReader(new StringReader(inputDocument));
            IndexDocument indexDocument = null;
            while (parser.hasNext()) {
                XMLEvent event = parser.nextEvent();
                if (event == null || !event.isStartElement()) continue;
                String localName = event.asStartElement().getName().getLocalPart();
                if (INDEX_RECORD_ID.equals(localName)) {
                    XMLEvent text = parser.nextEvent();
                    String recordId = this.getText(text);
                    indexDocument = callback.get(recordId);
                    indexDocument.addField(IndexMap.INDEX_RECORD_ID, recordId);
                    continue;
                }
                if (TARGETFIELDS.equals(localName)) {
                    this.parseTargetFields(indexDocument, parser);
                    continue;
                }
                if (!RESULTFIELD.equals(localName)) continue;
                this.copyResult(indexDocument, results, parser);
            }
            if (version != null) {
                indexDocument.addField(IndexMap.DS_VERSION, this.getParsedDateField(version));
            }
            return IndexDocument.STATUS.MARKED.equals((Object)indexDocument.getStatus()) ? indexDocument : indexDocument.setOK();
        }
        catch (XMLStreamException e) {
            log.warn((Object)("Parse exception in doc " + inputDocument), (Throwable)e);
            throw new DocumentException((Throwable)e);
        }
        catch (ParseException e) {
            throw new IllegalArgumentException("unable to parse field: " + version, e);
        }
    }

    protected void parseTargetFields(IndexDocument indexDocument, XMLEventReader parser) throws XMLStreamException {
        XMLEvent targetEvent;
        boolean hasFields = false;
        while (!(!parser.hasNext() || (targetEvent = parser.nextEvent()).isEndElement() && targetEvent.asEndElement().getName().getLocalPart().equals(TARGETFIELDS))) {
            if (!targetEvent.isStartElement()) continue;
            String fieldName = targetEvent.asStartElement().getName().getLocalPart();
            XMLEvent text = parser.nextEvent();
            String data = this.getText(text);
            this.addField(indexDocument, fieldName, data);
            hasFields = true;
        }
        if (!hasFields) {
            indexDocument.setMarked();
        }
    }

    protected void copyResult(IndexDocument indexDocument, StringWriter results, XMLEventReader parser) throws XMLStreamException {
        XMLEventWriter writer = this.outputFactory.get().createXMLEventWriter(results);
        ArrayList namespaces = Lists.newArrayList((Object[])new Namespace[]{this.eventFactory.get().createNamespace("dri", "http://www.driver-repository.eu/namespace/dri"), this.eventFactory.get().createNamespace("dr", "http://www.driver-repository.eu/namespace/dr"), this.eventFactory.get().createNamespace("xsi", "http://www.w3.org/2001/XMLSchema-instance"), this.eventFactory.get().createNamespace("dc", "http://purl.org/dc/elements/1.1/")});
        StartElement newRecord = this.eventFactory.get().createStartElement("", null, RESULTFIELD, null, namespaces.iterator());
        writer.add(newRecord);
        while (parser.hasNext()) {
            XMLEvent resultEvent = parser.nextEvent();
            if (resultEvent.isEndElement() && resultEvent.asEndElement().getName().getLocalPart().equals(RESULTFIELD)) {
                writer.add(resultEvent);
                break;
            }
            writer.add(resultEvent);
        }
        writer.close();
        indexDocument.addField(IndexMap.RESULT, results);
    }

    private final void addField(IndexDocument indexDocument, String field, String value) {
        String cleaned = value.trim();
        if (!cleaned.isEmpty()) {
            indexDocument.addField(field.toLowerCase(), cleaned);
        }
    }

    protected final String getText(XMLEvent text) {
        if (text.isEndElement()) {
            return "";
        }
        return text.asCharacters().getData();
    }
}

