/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.functionality.index.solr.feed.local;

import eu.dnetlib.functionality.index.solr.feed.FileType;
import eu.dnetlib.functionality.index.solr.feed.local.BlockingStream;
import eu.dnetlib.functionality.index.solr.feed.local.FileWalker;
import java.net.URISyntaxException;
import java.util.Iterator;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.SynchronousQueue;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DataProvider<T>
implements Iterable<T> {
    private static final Log log = LogFactory.getLog(DataProvider.class);
    private ExecutorService producer = Executors.newSingleThreadExecutor();
    private BlockingQueue<T> queue = new SynchronousQueue<T>();
    private String sourceURI = null;
    private FileType type;

    public DataProvider(FileType type) {
        this.type = type;
    }

    public DataProvider(FileType type, String sourceURI) {
        this(type);
        this.sourceURI = sourceURI;
    }

    @Override
    public Iterator<T> iterator() {
        if (this.sourceURI != null) {
            return this.readFilesUnder(this.sourceURI);
        }
        return null;
    }

    public BlockingStream<T> readFilesUnder(String sourcePath) {
        try {
            return this.doReadFilesUnder(sourcePath);
        }
        catch (Exception e) {
            log.error((Object)"ooops... ", (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    private BlockingStream<T> doReadFilesUnder(final String sourcePath) throws InterruptedException, ExecutionException, URISyntaxException {
        log.info((Object)("reading files under " + sourcePath));
        final FileWalker<T> walker = new FileWalker<T>(this.queue, this.type, sourcePath);
        this.producer.execute(new Runnable(){

            @Override
            public void run() {
                walker.doWalk();
                log.info((Object)("finished to iterate under " + sourcePath));
            }
        });
        return new BlockingStream<T>(this.queue);
    }
}

