/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.functionality.index.solr.feed.local;

import com.google.common.collect.Lists;
import eu.dnetlib.functionality.index.solr.feed.FileType;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Collection;
import java.util.concurrent.BlockingQueue;
import org.apache.commons.io.DirectoryWalker;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.tika.exception.TikaException;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.parser.pdf.PDFParser;
import org.apache.tika.sax.BodyContentHandler;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public class FileWalker<T>
extends DirectoryWalker {
    private static final Log log = LogFactory.getLog(FileWalker.class);
    private BlockingQueue<T> queue;
    private File source;
    private FileType type;
    public static final Object done = new Object();

    public FileWalker(BlockingQueue<T> queue, FileType type, String path) throws URISyntaxException {
        this.source = new File(new URI(path));
        this.type = type;
        this.queue = queue;
    }

    public void doWalk() {
        log.info((Object)("starting to iterate " + this.type.toString() + " files under " + this.source.getAbsolutePath()));
        try {
            this.walk(this.source, this.queue);
            this.enqueue(this.queue, done);
        }
        catch (IOException e) {
            log.error((Object)"could not read file ", (Throwable)e);
        }
    }

    protected void handleFile(File file, int depth, Collection results) throws IOException {
        try {
            this.enqueue((BlockingQueue)results, this.readFile(file));
        }
        catch (SAXException e) {
            throw new IOException(e);
        }
        catch (TikaException e) {
            throw new IOException(e);
        }
    }

    private void enqueue(BlockingQueue<T> queue, T element) {
        try {
            queue.put(element);
        }
        catch (InterruptedException e) {
            log.warn((Object)"ops... ", (Throwable)e);
        }
    }

    private String readFile(File file) throws IOException, SAXException, TikaException {
        FileInputStream fis = new FileInputStream(file);
        String fileContent = null;
        switch (this.type) {
            case TEXT: {
                StringWriter sw = new StringWriter();
                IOUtils.copy((InputStream)fis, (Writer)sw);
                sw.flush();
                fileContent = sw.toString();
                break;
            }
            case PDF: {
                BodyContentHandler textHandler = new BodyContentHandler();
                PDFParser parser = new PDFParser();
                parser.parse((InputStream)fis, (ContentHandler)textHandler, new Metadata());
                fileContent = textHandler.toString();
                break;
            }
            default: {
                throw new UnsupportedOperationException("FileType should be one of: " + Lists.newArrayList((Object[])FileType.values()));
            }
        }
        fis.close();
        return fileContent;
    }
}

