/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.functionality.index.solr.query;

import com.google.common.collect.Iterables;
import eu.dnetlib.functionality.index.cql.QueryOptions;
import eu.dnetlib.functionality.index.cql.TranslatedQuery;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import org.apache.commons.codec.DecoderException;
import org.apache.commons.codec.net.URLCodec;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.solr.client.solrj.SolrQuery;
import org.apache.solr.client.solrj.response.SpellCheckResponse;
import org.apache.solr.common.params.ModifiableSolrParams;
import org.apache.solr.common.params.SolrParams;
import org.z3950.zing.cql.CQLBooleanNode;
import org.z3950.zing.cql.CQLNode;
import org.z3950.zing.cql.CQLParseException;
import org.z3950.zing.cql.CQLPrefixNode;
import org.z3950.zing.cql.CQLSortNode;
import org.z3950.zing.cql.CQLTermNode;

public class IndexQuery
extends SolrQuery {
    private static final Log log = LogFactory.getLog(IndexQuery.class);
    private static final long serialVersionUID = -2265825542417494647L;
    private CQLNode queryRoot;

    public IndexQuery(TranslatedQuery query, CQLNode queryRoot, Map<String, List<String>> options) throws CQLParseException, IOException {
        this(query.asLucene(), options);
        this.setQueryRoot(queryRoot);
        this.setCqlParams(query.getOptions());
        log.debug((Object)("internal solr query: " + this.toString()));
    }

    public IndexQuery(String query, Map<String, List<String>> options) throws CQLParseException, IOException {
        this(query);
        super.add(this.getQueryParams(options));
    }

    public IndexQuery(String query) throws CQLParseException, IOException {
        super(query);
    }

    private void setCqlParams(QueryOptions options) {
        if (options != null && options.getSort() != null) {
            super.addSortField(options.getSort().getField(), SolrQuery.ORDER.valueOf((String)options.getSort().getMode().name()));
        }
    }

    private SolrParams getQueryParams(Map<String, List<String>> options) {
        ModifiableSolrParams params = new ModifiableSolrParams();
        String[] typeTag = new String[]{};
        for (Map.Entry<String, List<String>> entry : options.entrySet()) {
            params.add(entry.getKey(), entry.getValue().toArray(typeTag));
        }
        return params;
    }

    public String getQuery() {
        return super.getQuery();
    }

    public String toString() {
        try {
            return new String(URLCodec.decodeUrl((byte[])super.toString().getBytes()));
        }
        catch (DecoderException e) {
            throw new RuntimeException(e);
        }
    }

    public IndexQuery setQuery(String query) {
        super.setQuery(query);
        return this;
    }

    public void setQueryRoot(CQLNode queryRoot) {
        this.queryRoot = queryRoot;
    }

    public CQLNode getQueryRoot() {
        return this.queryRoot;
    }

    public IndexQuery applyHints(Map<String, SpellCheckResponse.Suggestion> suggestions) {
        this.setQueryRoot(this.doApplyHints(this.getQueryRoot(), suggestions));
        return this;
    }

    private CQLNode doApplyHints(CQLNode node, Map<String, SpellCheckResponse.Suggestion> suggestions) {
        if (node instanceof CQLPrefixNode || node instanceof CQLSortNode) {
            ((CQLPrefixNode)node).subtree = this.doApplyHints(((CQLPrefixNode)node).subtree, suggestions);
        }
        if (node instanceof CQLBooleanNode) {
            ((CQLBooleanNode)node).left = this.doApplyHints(((CQLBooleanNode)node).left, suggestions);
            ((CQLBooleanNode)node).right = this.doApplyHints(((CQLBooleanNode)node).right, suggestions);
        }
        if (node instanceof CQLTermNode) {
            CQLTermNode termNode = (CQLTermNode)node;
            StringTokenizer tokenizer = new StringTokenizer(termNode.getTerm());
            String alternateTerm = new String();
            while (tokenizer.hasMoreTokens()) {
                String token = tokenizer.nextToken();
                SpellCheckResponse.Suggestion s = suggestions.get(token);
                if (s != null) {
                    String hint = (String)Iterables.getFirst((Iterable)s.getAlternatives(), (Object)"");
                    alternateTerm = alternateTerm + (hint.equalsIgnoreCase(token) ? token : hint) + " ";
                    continue;
                }
                alternateTerm = alternateTerm + token + " ";
            }
            node = new CQLTermNode(termNode.getIndex(), termNode.getRelation(), alternateTerm.trim());
        }
        return node;
    }
}

