/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.functionality.index.solr.query;

import com.google.common.base.Predicate;
import com.google.common.collect.BiMap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import eu.dnetlib.functionality.index.solr.browsing.BrowsingRow;
import eu.dnetlib.functionality.index.solr.browsing.GroupResult;
import eu.dnetlib.functionality.index.solr.utils.IndexMap;
import eu.dnetlib.miscutils.collections.MappedCollection;
import eu.dnetlib.miscutils.functional.UnaryFunction;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.solr.client.solrj.response.FacetField;
import org.apache.solr.client.solrj.response.QueryResponse;
import org.apache.solr.client.solrj.response.SpellCheckResponse;
import org.apache.solr.common.SolrDocument;
import org.apache.solr.common.SolrDocumentList;

public class QueryResponseParser {
    private static final Log log = LogFactory.getLog(QueryResponseParser.class);
    private QueryResponse queryRsp;
    private UnaryFunction<String, String> highlightUtils;
    private BiMap<String, String> aliases;
    private boolean returnEmptyFields;
    private boolean includeRanking;
    private UnaryFunction<String, SolrDocument> wrapperRank = new UnaryFunction<String, SolrDocument>(){

        public String evaluate(SolrDocument doc) {
            return QueryResponseParser.this.addRanking(QueryResponseParser.this.getSingleField(doc, IndexMap.RESULT), QueryResponseParser.this.getSingleField(doc, IndexMap.SCORE_FIELD));
        }
    };
    private UnaryFunction<String, SolrDocument> wrapperNoRank = new UnaryFunction<String, SolrDocument>(){

        public String evaluate(SolrDocument doc) {
            return QueryResponseParser.this.wrap(QueryResponseParser.this.getSingleField(doc, IndexMap.RESULT));
        }
    };

    private String getSingleField(SolrDocument doc, String fieldName) {
        Object value = doc.getFieldValue(fieldName);
        if (value instanceof Collection) {
            return (String)Iterables.getOnlyElement((Iterable)((Iterable)value));
        }
        return String.valueOf(value);
    }

    public QueryResponseParser(QueryResponse queryRsp, UnaryFunction<String, String> highlightUtils, BiMap<String, String> aliases, boolean returnEmptyFields, boolean includeRanking) {
        this.queryRsp = queryRsp;
        this.highlightUtils = highlightUtils;
        this.aliases = aliases;
        this.returnEmptyFields = returnEmptyFields;
        this.includeRanking = includeRanking;
    }

    public SpellCheckResponse getSpellCheckResponse() {
        return this.queryRsp.getSpellCheckResponse();
    }

    public long getNumFound() {
        return this.queryRsp.getResults().getNumFound();
    }

    public int getQueryTime() {
        return this.queryRsp.getQTime();
    }

    public long getElapsedTime() {
        return this.queryRsp.getElapsedTime();
    }

    public String getStatus() {
        return String.valueOf(this.queryRsp.getStatus());
    }

    public int getCurrentSize() {
        return this.queryRsp.getResults().size();
    }

    public List<String> getResults() {
        return this.asRankedList(this.queryRsp.getResults());
    }

    public Long getNumberOfBrowsingResults() {
        List ffList = this.queryRsp.getFacetFields();
        Long maxCount = 0L;
        if (ffList != null) {
            for (FacetField ff : ffList) {
                Long countFacets;
                if (ff == null || (countFacets = this.countFacets(ff.getValues())) <= maxCount) continue;
                maxCount = countFacets;
            }
        }
        return maxCount;
    }

    private Long countFacets(List<FacetField.Count> facets) {
        if (facets == null) {
            return 0L;
        }
        return Iterables.size((Iterable)Iterables.filter(facets, (Predicate)new Predicate<FacetField.Count>(){

            public boolean apply(FacetField.Count c) {
                return c != null && c.getName() != null && !c.getName().isEmpty() && c.getCount() > 0L;
            }
        }));
    }

    public List<BrowsingRow> getBrowsingResults() {
        ArrayList bresList = Lists.newArrayList();
        ArrayList facets = Lists.newArrayList();
        List ffList = this.queryRsp.getFacetFields();
        Long numberOfBrowsingResults = this.getNumberOfBrowsingResults();
        int i = 0;
        while (ffList != null && (long)i < numberOfBrowsingResults) {
            for (FacetField ff : ffList) {
                FacetField.Count facet;
                String name = (String)this.aliases.inverse().get((Object)ff.getName());
                if (name == null) {
                    name = ff.getName();
                }
                if ((facet = this.getFacet(ff, i)) == null || facet.getCount() <= 0L) continue;
                String value = facet.getName();
                int count = (int)facet.getCount();
                if (!this.returnEmptyFields && value.isEmpty()) continue;
                facets.add(new GroupResult(name, value, count));
            }
            if (facets.size() > 0) {
                bresList.add(new BrowsingRow(Lists.newArrayList((Iterable)facets)));
                facets.clear();
            }
            ++i;
        }
        log.info((Object)("BrowsingResult size: " + bresList.size()));
        return bresList;
    }

    private FacetField.Count getFacet(FacetField ff, int pos) {
        if (ff.getValues() == null || pos >= ff.getValues().size()) {
            return null;
        }
        return (FacetField.Count)ff.getValues().get(pos);
    }

    private List<String> asRankedList(SolrDocumentList documentList) {
        UnaryFunction<String, SolrDocument> wrapper;
        UnaryFunction<String, SolrDocument> unaryFunction = wrapper = this.includeRanking ? this.wrapperRank : this.wrapperNoRank;
        if (this.queryRsp.getHighlighting() != null) {
            return MappedCollection.listMap((Iterable)MappedCollection.listMap((Iterable)documentList, (UnaryFunction)new UnaryFunction<String, SolrDocument>(){

                public String evaluate(SolrDocument doc) {
                    String score = QueryResponseParser.this.getSingleField(doc, IndexMap.SCORE_FIELD);
                    String hl = QueryResponseParser.this.getHighlighting(QueryResponseParser.this.getSingleField(doc, IndexMap.INDEX_RECORD_ID));
                    String res = hl != null ? hl : QueryResponseParser.this.getSingleField(doc, IndexMap.RESULT);
                    return QueryResponseParser.this.includeRanking ? QueryResponseParser.this.addRanking(res, score) : QueryResponseParser.this.wrap(res);
                }
            }), this.highlightUtils);
        }
        return MappedCollection.listMap((Iterable)documentList, wrapper);
    }

    private String addRanking(String doc, String score) {
        return new String("<record rank=\"" + score + "\">" + doc + "</record>");
    }

    private String wrap(String doc) {
        return new String("<record>" + doc + "</record>");
    }

    private String getHighlighting(String docId) {
        Map highlight = (Map)this.queryRsp.getHighlighting().get(docId);
        String result = new String();
        if (highlight != null && highlight.get(IndexMap.RESULT) != null) {
            for (String s : (List)highlight.get(IndexMap.RESULT)) {
                result = result.concat(s);
            }
            return result;
        }
        return null;
    }
}

