/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.functionality.index.solr.resultset;

import eu.dnetlib.data.index.IndexServiceException;
import eu.dnetlib.functionality.index.solr.SolrIndexServer;
import eu.dnetlib.functionality.index.solr.browsing.BrowsingRow;
import eu.dnetlib.functionality.index.solr.query.IndexQuery;
import eu.dnetlib.functionality.index.solr.query.QueryResponseParser;
import eu.dnetlib.functionality.index.solr.resultset.IndexResultSetListener;
import eu.dnetlib.functionality.index.solr.utils.MetadataReference;
import eu.dnetlib.miscutils.collections.MappedCollection;
import eu.dnetlib.miscutils.functional.UnaryFunction;
import eu.dnetlib.miscutils.jaxb.JaxbFactory;
import java.util.List;
import javax.xml.bind.JAXBException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class BrowsingResultSetListener
extends IndexResultSetListener {
    private static final Log log = LogFactory.getLog(BrowsingResultSetListener.class);
    private JaxbFactory<BrowsingRow> jaxbFactory;
    private int maxBrowseResults;

    public BrowsingResultSetListener(IndexQuery indexQuery, MetadataReference mdRef, SolrIndexServer solrIndexServer, JaxbFactory<BrowsingRow> jaxbFactory, int maxBrowseResults) throws IndexServiceException {
        super(indexQuery, mdRef, solrIndexServer);
        this.maxBrowseResults = maxBrowseResults;
        this.jaxbFactory = jaxbFactory;
        log.debug((Object)"BrowsingResultSetListener is up!");
    }

    @Override
    protected List<String> getContextualResult(QueryResponseParser responseParser, int from, int to) {
        return this.wrappedResults(responseParser.getBrowsingResults());
    }

    @Override
    protected IndexQuery getContextualQuery(IndexQuery indexQuery, int from, int to) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("getContextualResult BROWSING - from:" + from + " to: " + to));
            log.debug((Object)("indexQuery.setFacetLimit(" + (to - from + 1) + ").set(\"facet.offset\", " + (from - 1) + ")"));
        }
        indexQuery.setFacetSort("count");
        indexQuery.setFacetLimit(to - from + 1).set("facet.offset", from - 1);
        return indexQuery;
    }

    @Override
    protected int getContextualSize() {
        if (this.size == null) {
            try {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("setting BrowsingResultSetListener size with query: " + this.indexQuery.toString()));
                }
                this.indexQuery.setRows(0).setFacetSort("index");
                QueryResponseParser lookup = this.solrIndexServer.lookup(this.indexQuery, this.mdRef);
                this.size = lookup.getNumberOfBrowsingResults();
            }
            catch (Throwable e) {
                log.error((Object)"ops", e);
                throw new RuntimeException(e);
            }
        }
        if (this.size >= (long)this.maxBrowseResults) {
            return this.maxBrowseResults;
        }
        return this.size.intValue();
    }

    private List<String> wrappedResults(List<BrowsingRow> browsingResults) {
        return MappedCollection.listMap(browsingResults, (UnaryFunction)new UnaryFunction<String, BrowsingRow>(){

            public String evaluate(BrowsingRow value) {
                try {
                    return BrowsingResultSetListener.this.jaxbFactory.serialize((Object)value);
                }
                catch (JAXBException e) {
                    log.error((Object)"cannot serialize ", (Throwable)e);
                    throw new RuntimeException(e);
                }
            }
        });
    }
}

