/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.functionality.index.solr.resultset.factory;

import eu.dnetlib.data.index.IndexServiceException;
import eu.dnetlib.enabling.resultset.IterableResultSetFactory;
import eu.dnetlib.enabling.resultset.ResultSetFactory;
import eu.dnetlib.functionality.index.solr.feed.FileType;
import eu.dnetlib.functionality.index.solr.feed.local.DataProvider;
import eu.dnetlib.functionality.index.solr.query.QueryLanguage;
import eu.dnetlib.functionality.index.solr.resultset.factory.BrowsingResultSetListenerFactory;
import eu.dnetlib.functionality.index.solr.resultset.factory.LookupResultSetListenerFactory;
import eu.dnetlib.functionality.index.solr.utils.MetadataReference;
import javax.xml.ws.wsaddressing.W3CEndpointReference;
import org.springframework.beans.factory.annotation.Required;

public class IndexResultSetFactory {
    private LookupResultSetListenerFactory lookupResultSetListenerFactory;
    private BrowsingResultSetListenerFactory browsingResultSetListenerFactory;
    private IterableResultSetFactory iterableResultSetFactory;
    private ResultSetFactory resultsetFactory;

    public W3CEndpointReference getLookupResultSet(QueryLanguage lang, String query, MetadataReference mdRef, String ... dsId) throws IndexServiceException {
        return this.resultsetFactory.createResultSet(this.lookupResultSetListenerFactory.getListener(lang, query, mdRef, dsId));
    }

    public W3CEndpointReference getBrowsingResultSet(QueryLanguage lang, String query, MetadataReference mdRef, String ... dsId) throws IndexServiceException {
        return this.resultsetFactory.createResultSet(this.browsingResultSetListenerFactory.getListener(lang, query, mdRef, dsId));
    }

    public W3CEndpointReference getFileSystemResultSet(FileType type, String localURI) {
        return this.iterableResultSetFactory.createIterableResultSet(new DataProvider(type, localURI));
    }

    @Required
    public void setLookupResultSetListenerFactory(LookupResultSetListenerFactory lookupResultSetListenerFactory) {
        this.lookupResultSetListenerFactory = lookupResultSetListenerFactory;
    }

    @Required
    public void setBrowsingResultSetListenerFactory(BrowsingResultSetListenerFactory browsingResultSetListenerFactory) {
        this.browsingResultSetListenerFactory = browsingResultSetListenerFactory;
    }

    @Required
    public void setResultsetFactory(ResultSetFactory resultsetFactory) {
        this.resultsetFactory = resultsetFactory;
    }

    @Required
    public void setIterableResultSetFactory(IterableResultSetFactory iterableResultSetFactory) {
        this.iterableResultSetFactory = iterableResultSetFactory;
    }
}

