package eu.dnetlib.functionality.lightui.formatter;

import javax.servlet.http.HttpSession;

import org.springframework.core.io.Resource;

public class ResultFormatterFactory {

	private Resource xslt;
	private String openIndexTagHL = null;
	private String openHtmlTagHL = null;
	private String closeIndexTagHL = null;
	private String closeHtmlTagHL = null;

	public ResultFormatter newInstance(HttpSession session) {
		ResultFormatter formatter = new ResultFormatter();
		formatter.setXslt(xslt);
		formatter.setOpenHtmlTagHL(openHtmlTagHL);
		formatter.setOpenIndexTagHL(openIndexTagHL);
		formatter.setCloseHtmlTagHL(closeHtmlTagHL);
		formatter.setCloseIndexTagHL(closeIndexTagHL);
		formatter.init(session);
		return formatter;
	}

	public Resource getXslt() {
		return xslt;
	}

	public void setXslt(Resource xslt) {
		this.xslt = xslt;
	}

	public String getOpenIndexTagHL() {
		return openIndexTagHL;
	}

	public void setOpenIndexTagHL(String openIndexTagHL) {
		this.openIndexTagHL = openIndexTagHL;
	}

	public String getOpenHtmlTagHL() {
		return openHtmlTagHL;
	}

	public void setOpenHtmlTagHL(String openHtmlTagHL) {
		this.openHtmlTagHL = openHtmlTagHL;
	}

	public String getCloseIndexTagHL() {
		return closeIndexTagHL;
	}

	public void setCloseIndexTagHL(String closeIndexTagHL) {
		this.closeIndexTagHL = closeIndexTagHL;
	}

	public String getCloseHtmlTagHL() {
		return closeHtmlTagHL;
	}

	public void setCloseHtmlTagHL(String closeHtmlTagHL) {
		this.closeHtmlTagHL = closeHtmlTagHL;
	}
}
