package eu.dnetlib.functionality.lightui.utils;


import org.springframework.beans.factory.annotation.Required;
import eu.dnetlib.enabling.is.lookup.rmi.ISLookUpDocumentNotFoundException;
import eu.dnetlib.enabling.is.lookup.rmi.ISLookUpException;
import eu.dnetlib.enabling.is.lookup.rmi.ISLookUpService;
import eu.dnetlib.enabling.tools.ServiceLocator;

/**
 * The DynamicDriverCollection represents a Driver collection whose state is maintained in the Driver IS
 * 
 * @author marko
 *
 */
public class DynamicDriverCollection extends AbstractDriverCollection {

	protected ServiceLocator<ISLookUpService> lookupLocator;

	/**
	 * Fetches the membership condition from the Driver IS
	 * 
	 * @return CQL query source
	 * @throws ISLookUpException 
	 * @throws ISLookUpDocumentNotFoundException 
	 */
	public String getQuery() throws ISLookUpDocumentNotFoundException, ISLookUpException {
		ISLookUpService lookup = lookupLocator.getService();

		String query = "collection('/db/DRIVER/CollectionDSResources/CollectionDSResourceType')"
				+ "//CONFIGURATION[NAME='" + getName() + "']/MEMBERSHIP_CONDITION/text()";

		return lookup.getResourceProfileByQuery(query);
	}

	public ServiceLocator<ISLookUpService> getLookupLocator() {
		return lookupLocator;
	}

	@Required
	public void setLookupLocator(ServiceLocator<ISLookUpService> lookupLocator) {
		this.lookupLocator = lookupLocator;
	}
	
}
