package eu.dnetlib.functionality.lightui.utils;

import java.util.List;

import javax.xml.ws.wsaddressing.W3CEndpointReference;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import eu.dnetlib.enabling.resultset.rmi.ResultSetException;
import eu.dnetlib.enabling.resultset.rmi.ResultSetService;
import eu.dnetlib.enabling.tools.ServiceResolver;

public class ResultSet {

	private static final Log log = LogFactory.getLog(ResultSet.class); // NOPMD by marko on 11/24/08 5:02 PM

	private W3CEndpointReference epr;
	private Integer numberOfElements = null;
	private String rsId = null;

	private ServiceResolver serviceResolver;

	public ResultSet(W3CEndpointReference epr, ServiceResolver serviceResolver) {
		this.epr = epr;
		this.serviceResolver = serviceResolver;

		this.rsId = serviceResolver.getResourceIdentifier(epr);
	}

	public int getNumberOfElements() throws ResultSetException {
		ResultSetService resultset = serviceResolver.getService(ResultSetService.class, epr);

		if (numberOfElements == null)
			numberOfElements = resultset.getNumberOfElements(rsId);
		return numberOfElements;
	}

	public W3CEndpointReference getEpr() {
		return epr;
	}

	public void setEpr(W3CEndpointReference epr) {
		this.epr = epr;
	}

	public List<String> getResult(int fromPosition, int toPosition) throws ResultSetException {
		if(log.isDebugEnabled())
			log.debug("Getting result " + fromPosition + " -> " + toPosition);

		ResultSetService resultset = serviceResolver.getService(ResultSetService.class, epr);

		log.debug("executing getResult ");
		return resultset.getResult(rsId, fromPosition, toPosition, "WAITING");
	}

	public ServiceResolver getServiceResolver() {
		return serviceResolver;
	}

	public void setServiceResolver(ServiceResolver serviceResolver) {
		this.serviceResolver = serviceResolver;
	}


}
