package eu.dnetlib.functionality.lightui.web;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;

import javax.servlet.ServletResponse;

import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;

@Controller
public class LightuiDefaultStaticFilesController {

	private final Map<String, String> extToMime = new HashMap<String, String>();

	private static final Log log = LogFactory.getLog(LightuiDefaultStaticFilesController.class); // NOPMD by marko on 11/24/08 5:02 PM
	
	public LightuiDefaultStaticFilesController() {
		extToMime.put("js", "text/javascript");
		extToMime.put("css", "text/css");
		extToMime.put("png", "image/png");
		extToMime.put("jpg", "image/jpeg");
		extToMime.put("gif", "image/gif");
	}

	@RequestMapping(value = "static.get")
	public void stat(ServletResponse response, OutputStream out, @RequestParam(value = "src", required = true) final String src) throws Exception {
		if (renderStatic(response, out, src)) {
			log.info("Static file " + src);
		} else {
			log.warn("Static file " + src + " NOT FOUND");
		}
	}

	protected boolean renderStatic(final ServletResponse response, final OutputStream output, final String name) throws IOException {
		String ext = name.substring(name.lastIndexOf('.') + 1, name.length());
		String path = "/eu/dnetlib/functionality/lightui/web/resources/";
		if      (ext.equalsIgnoreCase("js"))  path += "js/";
		else if (ext.equalsIgnoreCase("css")) path += "css/";
		else                                  path += "images/";
		return renderStatic(response, output, getClass().getResourceAsStream(path + name), extToMime.get(ext));
	}

	protected boolean renderStatic(final ServletResponse response, final OutputStream output, final InputStream input, final String contentType) throws IOException {
		if (input != null) {
			response.setContentType(contentType);
			IOUtils.copy(input, output);
			return true;
		}
		return false;
	}
}
