package org.z3950.zing.cql;

import java.util.Properties;
import java.util.Vector;

import org.z3950.zing.cql.CQLNode;
import org.z3950.zing.cql.CQLPrefix;
import org.z3950.zing.cql.ModifierSet;
import org.z3950.zing.cql.PQFTranslationException;

/**
 * This is ugly hack, a sentinel value used to tag a cql node with a BBQ name, so that it can later be unwrapped in a
 * qualified AND chain.
 *
 * @author marko
 *
 */
public class CQLBBQNode extends CQLNode {

	private CQLNode node;

	private String bbqName;

	public CQLBBQNode(final String bbqName, final CQLNode node) {
		super();
		this.bbqName = bbqName;
		this.node = node;
	}

	@Override
	public String toCQL() {
		return node.toCQL();
	}

	@Override
	public String toPQF(Properties arg0) throws PQFTranslationException {
		return node.toPQF(arg0);
	}

	@Override
	public byte[] toType1BER(Properties arg0) throws PQFTranslationException {
		return node.toType1BER(arg0);
	}

	@Override
	public String toXCQL(int arg0, Vector<CQLPrefix> arg1, Vector<ModifierSet> arg2) {
		return node.toXCQL(arg0, arg1, arg2);
	}

	public CQLNode getNode() {
		return node;
	}

	public void setNode(CQLNode node) {
		this.node = node;
	}

	public String getBbqName() {
		return bbqName;
	}

	public void setBbqName(String bbqName) {
		this.bbqName = bbqName;
	}

}
