package eu.dnetlib.functionality.lightui.utils;

import javax.xml.ws.wsaddressing.W3CEndpointReference;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import eu.dnetlib.enabling.tools.ServiceResolver;

/**
 * This caching service resolver avoids the CXF overhead.
 *
 * Very stupid 1 entry cache.
 *
 * @author marko
 *
 */
public class CachingServiceResolver implements ServiceResolver {

	private static final Log log = LogFactory.getLog(CachingServiceResolver.class); // NOPMD by marko on 11/24/08 5:02 PM


	private ServiceResolver resolver;

	Object cached;

	public String getResourceIdentifier(W3CEndpointReference epr) {
		return resolver.getResourceIdentifier(epr);
	}

	@SuppressWarnings("unchecked")
	public <T> T getService(Class<T> clazz, W3CEndpointReference epr) {
		if(log.isDebugEnabled())
			log.debug("should resolve stub for epr " + epr);

		if (cached == null)
			cached = resolver.getService(clazz, epr);

		return (T) cached;
	}

	public ServiceResolver getResolver() {
		return resolver;
	}

	public void setResolver(ServiceResolver resolver) {
		this.resolver = resolver;
	}

}
