package eu.dnetlib.functionality.lightui.utils;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import eu.dnetlib.data.information.publisher.rmi.PublisherService;
import eu.dnetlib.enabling.tools.ServiceLocator;

public class NoCachingPublisherClientImpl implements CachingPublisherClient {
	private static final Log log = LogFactory.getLog(NoCachingPublisherClientImpl.class); // NOPMD by marko on 11/24/08 5:02 PM

	ServiceLocator<PublisherService> publisherLocator;

	public String getResourceById(String id, String format) {
		return publisherLocator.getService().getResourceById(id, format);
	}

	public void updateRecord(String objIdentifier, String mainFormat, String element) {
		log.debug("fake publisher cache update record");
	}

	public ServiceLocator<PublisherService> getPublisherLocator() {
		return publisherLocator;
	}

	public void setPublisherLocator(ServiceLocator<PublisherService> publisherLocator) {
		this.publisherLocator = publisherLocator;
	}

}
