package eu.dnetlib.functionality.lightui.web;

import java.util.concurrent.Future;

import javax.annotation.Resource;
import javax.xml.ws.wsaddressing.W3CEndpointReference;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Required;

import eu.dnetlib.data.index.IIndexService;
import eu.dnetlib.data.index.IndexServiceException;
import eu.dnetlib.enabling.tools.ServiceLocator;
import eu.dnetlib.functionality.lightui.utils.ResultSet;
import eu.dnetlib.functionality.lightui.utils.ResultSetFactory;

public class SynchronousSearchEngine implements SearchEngine {

	protected Log log = LogFactory.getLog(SynchronousSearchEngine.class);

	@Resource(name = "lightuiIndexLocator")
	protected ServiceLocator<IIndexService> indexLocator;

	@Resource(name = "lightuiResultSetFactory")
	protected ResultSetFactory resultSetFactory;

	private boolean withHighlight;

	private String defaultQuery;

	@Override
	public ResultSet resultSetForQueryOrEpr(String query, String metadataFormat, W3CEndpointReference epr) throws IndexServiceException {
		if (epr == null) {
			String q = "";
			if (withHighlight && !query.trim().equalsIgnoreCase(defaultQuery.trim()))
				q = ">solr=NAMESPACE solr.hl=true and ";
			q += query;

			log.debug("executing query:" + q);
			epr = indexLocator.getService().indexLookup("all", q, metadataFormat, "index");
		}
		return resultSetFactory.newInstance(epr);
	}

	@Override
	public Future<ResultSet> prepareQuery(String cqlQuery, String metadataFormat) {
		return null;
	}

	@Required
	public void setWithHighlight(boolean withHighlight) {
		this.withHighlight = withHighlight;
	}

	public boolean isWithHighlight() {
		return withHighlight;
	}

	public String getDefaultQuery() {
		return defaultQuery;
	}

	@Required
	public void setDefaultQuery(String defaultQuery) {
		this.defaultQuery = defaultQuery;
	}
}
