/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.functionality.lightui.utils;

import eu.dnetlib.enabling.is.lookup.rmi.ISLookUpException;
import eu.dnetlib.enabling.is.lookup.rmi.ISLookUpService;
import eu.dnetlib.enabling.tools.ServiceLocator;
import java.io.IOException;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.List;
import javax.annotation.Resource;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.z3950.zing.cql.CQLNode;
import org.z3950.zing.cql.CQLOrNode;
import org.z3950.zing.cql.CQLParseException;
import org.z3950.zing.cql.CQLParser;

public class ODL_Utils {
    protected Log log = LogFactory.getLog(ODL_Utils.class);
    private DocumentBuilder parser = DocumentBuilderFactory.newInstance().newDocumentBuilder();
    private String xsltPath = "";
    @Resource(name="lookupLocator")
    ServiceLocator<ISLookUpService> lookupLocator;

    public ODL_Utils() throws ParserConfigurationException {
    }

    public ODL_Utils(String xsltpath) throws ParserConfigurationException {
        this.xsltPath = xsltpath;
    }

    public String[] splitRepository(String query) {
        CQLParser parser = new CQLParser();
        try {
            CQLNode root = parser.parse(query);
            if (root instanceof CQLOrNode) {
                query = query.replaceAll("\\) or \\(", "|");
                query = query.replaceAll("\\(repositoryName = \"", "");
                query = query.replaceAll("repositoryName = \"", "");
                query = query.replaceAll("\"\\)", "");
                query = query.replaceAll("\"", "");
                return query.split("\\|");
            }
        }
        catch (CQLParseException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return new String[0];
    }

    public String cleanRepository(String docXML) {
        try {
            Document doc = this.parser.parse(new InputSource(new StringReader(docXML)));
            Element root = doc.getDocumentElement();
            String query = root.getTextContent();
            return query;
        }
        catch (SAXException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return null;
    }

    public String viewDocument(String docXML) {
        try {
            Document doc = this.parser.parse(new InputSource(new StringReader(docXML)));
            DOMSource xmlDomSource = new DOMSource(doc);
            TransformerFactory tFactory = TransformerFactory.newInstance();
            Transformer transformer = tFactory.newTransformer(new StreamSource(this.xsltPath));
            StringWriter strw = new StringWriter();
            transformer.transform(xmlDomSource, new StreamResult(strw));
            return strw.toString();
        }
        catch (SAXException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (TransformerConfigurationException e) {
            e.printStackTrace();
        }
        catch (TransformerException e) {
            e.printStackTrace();
        }
        return null;
    }

    public static String ltrim(String source) {
        return source.replaceAll("^\\s+", "");
    }

    public static String rtrim(String source) {
        return source.replaceAll("\\s+$", "");
    }

    public static String trim(String source) {
        return ODL_Utils.ltrim(ODL_Utils.rtrim(source));
    }

    public List<String> listItemsForVocabulary(String voc) throws ISLookUpException {
        return ((ISLookUpService)this.lookupLocator.getService()).quickSearchProfile("//TERM[../../VOCABULARY_NAME='" + voc + "']/@english_name/string()");
    }
}

