/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.functionality.lightui.web;

import eu.dnetlib.data.index.IndexServiceException;
import eu.dnetlib.enabling.is.lookup.rmi.ISLookUpDocumentNotFoundException;
import eu.dnetlib.enabling.is.lookup.rmi.ISLookUpException;
import eu.dnetlib.functionality.lightui.browse.BrowseStatsEngine;
import eu.dnetlib.functionality.lightui.formatter.ResultFormatter;
import eu.dnetlib.functionality.lightui.formatter.ResultFormatterFactory;
import eu.dnetlib.functionality.lightui.utils.Base64Coder;
import eu.dnetlib.functionality.lightui.utils.CachingPublisherClient;
import eu.dnetlib.functionality.lightui.utils.DriverCollection;
import eu.dnetlib.functionality.lightui.utils.DriverCollectionDao;
import eu.dnetlib.functionality.lightui.utils.EPRUtil;
import eu.dnetlib.functionality.lightui.utils.ODL_Utils;
import eu.dnetlib.functionality.lightui.utils.Querable;
import eu.dnetlib.functionality.lightui.utils.QueryBuilder;
import eu.dnetlib.functionality.lightui.utils.Repository;
import eu.dnetlib.functionality.lightui.utils.ResultSet;
import eu.dnetlib.functionality.lightui.web.SearchEngine;
import eu.dnetlib.miscutils.dom4j.XPathHelper;
import eu.dnetlib.soap.cxf.StandaloneCxfEndpointReferenceBuilder;
import java.io.IOException;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import javax.xml.ws.wsaddressing.W3CEndpointReference;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Required;
import org.springframework.security.context.SecurityContext;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.z3950.zing.cql.CQLNode;
import org.z3950.zing.cql.CQLParseException;

public class MainController {
    protected Log log = LogFactory.getLog(MainController.class);
    public static final String SESSION_PARAM_PREFIX = "session_param";
    @Resource
    protected ODL_Utils utils;
    @Resource
    private StandaloneCxfEndpointReferenceBuilder eprBuilder;
    private DriverCollectionDao collectionDao;
    @Resource
    private SearchEngine searchEngine;
    @Resource
    private BrowseStatsEngine browseEngine;
    @Resource
    protected CachingPublisherClient publisher;
    private String logoutURL;
    private int pageSize = 10;
    private boolean useBbqs = false;
    private String mainFormat;
    private String toolsPage;
    private ResultFormatterFactory rowFormatterFactory;
    private ResultFormatterFactory documentFormatterFactory;
    @Resource
    private QueryBuilder queryBuilder;
    private List<String> browseFields;

    protected void prepareCommonEnvironment(ModelMap map) throws ISLookUpException {
        Collection<DriverCollection> collections = this.collectionDao.getCollections();
        LinkedHashSet<Repository> allRepositories = new LinkedHashSet<Repository>();
        for (DriverCollection collection : collections) {
            allRepositories.addAll(collection.getRepositories());
        }
        map.addAttribute("repositoryObjects", allRepositories);
        map.addAttribute("toolsPage", (Object)this.toolsPage);
    }

    @RequestMapping(value={"index.do"})
    public void mainPage(ModelMap map, HttpServletRequest request) throws ISLookUpException {
        this.prepareCommonEnvironment(map);
        this.updateSession(request);
        this.fillMapWithSessionParams(map, request.getSession());
        Collection<DriverCollection> collections = this.collectionDao.getCollections();
        LinkedHashSet<Repository> allRepositories = new LinkedHashSet<Repository>();
        for (DriverCollection collection : collections) {
            allRepositories.addAll(collection.getRepositories());
        }
        map.addAttribute("collections", this.base64Querables(collections));
        map.addAttribute("repositories", this.base64Querables(allRepositories));
        map.addAttribute("languages", this.collectionDao.getLanguages());
    }

    @RequestMapping(value={"results.do"})
    public void results(ModelMap map, HttpServletRequest request) throws CQLParseException, IOException, NoSuchAlgorithmException, ISLookUpException {
        this.prepareCommonEnvironment(map);
        this.updateSession(request);
        this.fillMapWithSessionParams(map, request.getSession());
        this.log.info((Object)"showing results ");
        HashMap<String, String[]> parameters = new HashMap<String, String[]>(request.getParameterMap());
        CQLNode query = this.queryBuilder.getQuery(parameters);
        String cqlQuery = query.toCQL();
        this.log.info((Object)cqlQuery);
        this.searchEngine.prepareQuery(cqlQuery, this.mainFormat);
        map.addAttribute("query", (Object)cqlQuery.replaceAll("'", "\\'"));
        map.addAttribute("queryEscaped", (Object)StringEscapeUtils.escapeXml((String)cqlQuery));
        HashMap<String, String> params = new HashMap<String, String>();
        Enumeration names = request.getParameterNames();
        while (names.hasMoreElements()) {
            String key = (String)names.nextElement();
            String[] values = request.getParameterValues(key);
            if (values.length != 1 || values[0] == null || values[0].isEmpty()) continue;
            String value = values[0];
            if (values[0].contains("||")) {
                value = value.substring(value.indexOf("||") + 2);
            }
            params.put(key, StringEscapeUtils.escapeXml((String)value));
        }
        map.addAttribute("params", params);
    }

    @RequestMapping(value={"resultsCQL.do"})
    public void resultsCQL(ModelMap map, HttpServletRequest request, @RequestParam(value="query", required=true) String cqlQuery) throws ISLookUpException {
        this.prepareCommonEnvironment(map);
        this.fillMapWithSessionParams(map, request.getSession());
        this.log.info((Object)"showing results ");
        this.searchEngine.prepareQuery(cqlQuery, this.mainFormat);
        map.addAttribute("query", (Object)cqlQuery.replaceAll("'", "\\'"));
        map.addAttribute("queryEscaped", (Object)StringEscapeUtils.escapeXml((String)cqlQuery));
    }

    @RequestMapping(value={"query.do"})
    public String results(ModelMap map, HttpSession session, @RequestParam(value="query", required=false) String query, @RequestParam(value="PageNumber", required=false) Integer page, @RequestParam(value="rsId", required=false) String rsId, @RequestParam(value="resultset_address", required=false) String rsAddress, @RequestParam(value="mobile", required=false) Object mobile) {
        String view = "query";
        String view_empty = "emptyQuery";
        if (mobile != null) {
            view = "query_mobile";
            view_empty = "emptyQuery_mobile";
        }
        try {
            this.log.info((Object)"query.do");
            this.fillMapWithSessionParams(map, session);
            if (page == null) {
                page = 1;
            }
            int fromPosition = 1 + (page - 1) * this.pageSize;
            int toPosition = fromPosition + this.pageSize - 1;
            W3CEndpointReference epr = null;
            if (rsId != null) {
                epr = this.eprBuilder.getEndpointReference(rsAddress, null, null, rsAddress + "?wsdl", rsId, null);
            }
            ResultSet resultset = this.searchEngine.resultSetForQueryOrEpr(query, this.mainFormat, epr);
            epr = resultset.getEpr();
            int maxElements = resultset.getNumberOfElements();
            if (maxElements == 0) {
                return view_empty;
            }
            int pages = (int)Math.ceil((float)maxElements / (float)this.pageSize);
            LinkedHashMap<String, String> rowMap = new LinkedHashMap<String, String>();
            List<String> rawResults = resultset.getResult(fromPosition, toPosition);
            ResultFormatter ff = this.rowFormatterFactory.newInstance(session);
            for (String element : rawResults) {
                String row = ff.viewDocument(element);
                String objIdentifier = XPathHelper.selectElement((String)element, (String)"//*[local-name()='objIdentifier']").getText();
                this.publisher.updateRecord(objIdentifier, this.getMainFormat(), element);
                rowMap.put(objIdentifier, row);
            }
            map.addAttribute("query", (Object)query);
            map.addAttribute("maxElements", (Object)maxElements);
            map.addAttribute("rows", rowMap);
            map.addAttribute("rsId", (Object)EPRUtil.getResourceIdentifier(epr));
            map.addAttribute("rsAddress", (Object)EPRUtil.getAddress(epr));
            map.addAttribute("format", (Object)this.mainFormat);
            ArrayList<Integer> prevPages = new ArrayList<Integer>();
            ArrayList<Integer> nextPages = new ArrayList<Integer>();
            int pageWindow = 10;
            int firstNavigablePage = page - pageWindow / 2;
            if (firstNavigablePage <= 0) {
                firstNavigablePage = 1;
            }
            if (firstNavigablePage + pageWindow >= pages) {
                pageWindow = pages - firstNavigablePage + 1;
            }
            for (int i = 0; i < pageWindow; ++i) {
                int p = firstNavigablePage + i;
                if (p < page) {
                    prevPages.add(p);
                    continue;
                }
                if (p <= page) continue;
                nextPages.add(p);
            }
            map.addAttribute("pages", (Object)pages);
            map.addAttribute("currentPage", (Object)page);
            if (page > 1) {
                map.addAttribute("prevPage", (Object)(page - 1));
                map.addAttribute("prevPages", prevPages);
            }
            if (page < pages) {
                map.addAttribute("nextPage", (Object)(page + 1));
                map.addAttribute("nextPages", nextPages);
            }
            this.log.debug((Object)"Rendering results");
            return view;
        }
        catch (Exception e) {
            this.log.error((Object)"Error occurred", (Throwable)e);
            e.printStackTrace();
            return view_empty;
        }
    }

    @RequestMapping(value={"browseStats.do"})
    public String browseStats(ModelMap map, HttpSession session, @RequestParam(value="query", required=false) String query) {
        try {
            this.log.info((Object)"browseStats.do");
            this.fillMapWithSessionParams(map, session);
            map.addAttribute("browseStats", this.browseEngine.getBrowseStats(query, this.mainFormat, this.browseFields));
            return "browseStats";
        }
        catch (Exception e) {
            this.log.error((Object)"Error obtaining browse stats", (Throwable)e);
            return "emptyBrowseStats";
        }
    }

    @RequestMapping(value={"documentCQL.do"})
    public String getDocumentCQL(ModelMap map, @RequestParam(value="key", required=false) String key, @RequestParam(value="value", required=false) String value, @RequestParam(value="query", required=false) String query) {
        try {
            if (query == null || query.length() == 0) {
                query = key != null && key.length() > 0 ? key + "=\"" + value + "\"" : "\"" + value + "\"";
            }
            this.log.info((Object)("Searching for document: " + query));
            this.searchEngine.prepareQuery(query, this.mainFormat);
            W3CEndpointReference epr = null;
            ResultSet resultset = this.searchEngine.resultSetForQueryOrEpr(query, this.mainFormat, epr);
            epr = resultset.getEpr();
            int maxElements = resultset.getNumberOfElements();
            if (maxElements == 0) {
                return "emptyQuery";
            }
            List<String> rawResults = resultset.getResult(1, 1);
            String element = rawResults.get(0);
            String id = XPathHelper.selectElement((String)element, (String)"//*[local-name()='objIdentifier']").getText();
            return "redirect:document.do?id=" + id;
        }
        catch (Exception e) {
            this.log.error((Object)"Error occurred", (Throwable)e);
            e.printStackTrace();
            return "emptyQuery";
        }
    }

    @RequestMapping(value={"document.do"})
    public void document(ModelMap map, HttpServletRequest request, @RequestParam(value="id") String id) {
        HttpSession session = request.getSession();
        String body = this.publisher.getResourceById(id, this.mainFormat);
        this.updateSession(request);
        this.fillMapWithSessionParams(map, session);
        map.addAttribute("id", (Object)id);
        map.addAttribute("format", (Object)this.mainFormat);
        map.addAttribute("body", (Object)this.documentFormatterFactory.newInstance(session).viewDocument(body));
    }

    @RequestMapping(value={"vocabularies.do"})
    public String vocabularies(ModelMap map, HttpServletRequest request, @RequestParam(required=true, value="v") String vocabularies) throws Exception {
        HashMap<String, List<String>> vocs = new HashMap<String, List<String>>();
        for (String s : vocabularies.split(",")) {
            String voc = s.trim();
            vocs.put(voc, this.utils.listItemsForVocabulary(voc));
        }
        map.addAttribute("vocabularies", vocs);
        return "vocabularies";
    }

    @RequestMapping(value={"logout.do"})
    public String logout(HttpSession session) {
        SecurityContext context = (SecurityContext)session.getAttribute("SPRING_SECURITY_CONTEXT");
        context.setAuthentication(null);
        return "redirect:" + this.logoutURL;
    }

    protected ResultSet resultSetForQueryOrEpr(String query, W3CEndpointReference epr) throws IndexServiceException {
        return this.searchEngine.resultSetForQueryOrEpr(query, this.mainFormat, epr);
    }

    private void clearSession(HttpServletRequest request) {
        HttpSession session = request.getSession();
        Enumeration oldnames = session.getAttributeNames();
        while (oldnames.hasMoreElements()) {
            session.removeAttribute(oldnames.nextElement().toString());
        }
        this.log.info((Object)"Session params cleaned");
    }

    private void updateSession(HttpServletRequest request) {
        if (request.getParameterMap().containsKey("_newsession")) {
            this.clearSession(request);
        }
        HttpSession session = request.getSession();
        Enumeration names = request.getParameterNames();
        while (names.hasMoreElements()) {
            String name = names.nextElement().toString();
            String[] values = request.getParameterValues(name);
            if (!name.startsWith("_") || name.equals("_newsession") || values.length <= 0) continue;
            session.setAttribute(SESSION_PARAM_PREFIX + name, (Object)values[0]);
        }
    }

    private void fillMapWithSessionParams(ModelMap map, HttpSession session) {
        if (session == null) {
            return;
        }
        map.addAttribute("session", (Object)session);
        Enumeration names = session.getAttributeNames();
        while (names.hasMoreElements()) {
            String name = names.nextElement().toString();
            map.addAttribute(name, session.getAttribute(name));
            this.log.info((Object)("session element " + name + " has value: " + session.getAttribute(name)));
            this.log.info((Object)("Param " + name));
        }
    }

    protected Map<String, String> base64Querables(Collection<? extends Querable> querables) throws ISLookUpDocumentNotFoundException, ISLookUpException {
        LinkedHashMap<String, String> encodedQuerables = new LinkedHashMap<String, String>();
        for (Querable querable : querables) {
            encodedQuerables.put(Base64Coder.encodeString(querable.getQuery()), querable.getAlias());
        }
        return encodedQuerables;
    }

    public int getPageSize() {
        return this.pageSize;
    }

    public void setPageSize(int pageSize) {
        this.pageSize = pageSize;
    }

    public DriverCollectionDao getCollectionDao() {
        return this.collectionDao;
    }

    public void setCollectionDao(DriverCollectionDao collectionDao) {
        this.collectionDao = collectionDao;
    }

    public boolean isUseBbqs() {
        return this.useBbqs;
    }

    public void setUseBbqs(boolean useBbqs) {
        this.useBbqs = useBbqs;
    }

    public String getMainFormat() {
        return this.mainFormat;
    }

    @Required
    public void setMainFormat(String mainFormat) {
        this.mainFormat = mainFormat;
    }

    public ResultFormatterFactory getRowFormatterFactory() {
        return this.rowFormatterFactory;
    }

    public void setRowFormatterFactory(ResultFormatterFactory rowFormatterFactory) {
        this.rowFormatterFactory = rowFormatterFactory;
    }

    public ResultFormatterFactory getDocumentFormatterFactory() {
        return this.documentFormatterFactory;
    }

    public void setDocumentFormatterFactory(ResultFormatterFactory documentFormatterFactory) {
        this.documentFormatterFactory = documentFormatterFactory;
    }

    public QueryBuilder getQueryBuilder() {
        return this.queryBuilder;
    }

    public void setQueryBuilder(QueryBuilder queryBuilder) {
        this.queryBuilder = queryBuilder;
    }

    public List<String> getBrowseFields() {
        return this.browseFields;
    }

    @Required
    public void setBrowseFields(List<String> browseFields) {
        this.browseFields = browseFields;
    }

    public String getLogoutURL() {
        return this.logoutURL;
    }

    public void setLogoutURL(String logoutURL) {
        this.logoutURL = logoutURL;
    }

    public String getToolsPage() {
        return this.toolsPage;
    }

    public void setToolsPage(String toolsPage) {
        this.toolsPage = toolsPage;
    }
}

