<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0"  xmlns:dr="http://www.driver-repository.eu/namespace/dr" xmlns:dc="http://purl.org/dc/elements/1.1/" xmlns:oaf="http://namespace.openaire.eu/oaf" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
<!-- Based on DMF stylesheet -->

	<xsl:output method="html" version="1.0" encoding="UTF-8" indent="yes"/>
	<xsl:template match="/">
		<xsl:apply-templates select="//metadata"/>
		<br />
		<br />
		<xsl:for-each select="//metadata">
			<fieldset style="font-size:11px;">
				<xsl:call-template name="xmlItem">
					<xsl:with-param name="indent" select="string('')" />
				</xsl:call-template>
			</fieldset>
		</xsl:for-each>
	</xsl:template>
	
	<xsl:template name="separator">
		<tr>
			<td colspan="3" class="separator"><xsl:text>  </xsl:text></td>
		</tr>
	</xsl:template>
	
	<xsl:template match="//metadata">
		<xsl:variable name = "link_repo" select = "dr:repositoryLink"></xsl:variable>
	
		<xsl:for-each select="dr:repositoryName">
			<h3><xsl:value-of select="."/></h3>
		</xsl:for-each>
		<xsl:for-each select="dc:title">
			<h4><xsl:apply-templates select="." mode="richText"/></h4>
		</xsl:for-each>
		<br/>
		<table class="listing" width="100%">
			<tbody>
				<xsl:if test="count(dc:title) > '0'">
					<tr>
						<td>Title</td>
						<td>
							<xsl:apply-templates select="dc:title" mode="content"/>
						</td>
					</tr>
					<xsl:call-template name="separator"/>
				</xsl:if>
				<xsl:if test="count(dc:creator) > '0'">
					<tr>
						<td>Author</td>
						<td>
						  <ul class="authorList">
						    <xsl:apply-templates select="dc:creator" mode="content"/>
						  </ul>
						</td>
					</tr>
					<xsl:call-template name="separator"/>
				</xsl:if>
				<xsl:if test="count(dc:contributor) > '0'">
					<tr>
						<td>Contributor</td>
						<td>
						  <ul class="authorList">
						    <xsl:apply-templates select="dc:contributor" mode="content"/>
						  </ul>
						</td>
					</tr>
					<xsl:call-template name="separator"/>
				</xsl:if>
				<xsl:if test="count(dc:subject) > '0'">
					<tr>
						<td>Subject</td>
						<td>
   						<ul class="subjectList">
						    <xsl:apply-templates select="dc:subject" mode="content"/>
						  </ul>
						</td>
					</tr>
					<xsl:call-template name="separator"/>
				</xsl:if>
				<xsl:if test="count(dc:description) > '0'">
					<tr>
						<td>Description</td>
						<td>
						  <xsl:apply-templates select="dc:description" mode="content"/>
						</td>
					</tr>
					<xsl:call-template name="separator"/>
				</xsl:if>
				<xsl:if test="count(dc:publisher) > '0'">
					<tr>
						<td>Institution</td>
						<td>
							<xsl:for-each select="dc:publisher">
								<xsl:value-of select="."/><br/>
							</xsl:for-each>
						</td>
					</tr>
					<xsl:call-template name="separator"/>
				</xsl:if>
				<xsl:if test="count(dc:dateAccepted) > '0'">
					<tr>
						<td>Date</td>
						<td>
							<xsl:for-each select="dc:dateAccepted">
								<xsl:value-of select="."/><br/>
							</xsl:for-each>
						</td>
					</tr>
					<xsl:call-template name="separator"/>
				</xsl:if>
				<xsl:if test="count(dc:format) > '0'">
					<tr>
						<td>Format</td>
						<td>
							<xsl:for-each select="dc:format">
								<xsl:value-of select="."/><br/>
							</xsl:for-each>
						</td>
					</tr>
					<xsl:call-template name="separator"/>
				</xsl:if>
				<xsl:if test="count(dc:identifier) > '0'">
					<tr>
						<td>URL</td>
						<td>
							<xsl:for-each select="dc:identifier">
								<xsl:variable name = "link" select = "."></xsl:variable>
								<a href="{$link}"><xsl:value-of select="."/></a><br/>
							</xsl:for-each>
						</td>
					</tr>
					<xsl:call-template name="separator"/>
				</xsl:if>
				<xsl:if test="count(dc:type) > '0'">
					<tr>
						<td>Type</td>
						<td>
							<xsl:for-each select="dc:type">
								<xsl:value-of select="."/><br/>
							</xsl:for-each>
						</td>
					</tr>
					<xsl:call-template name="separator"/>
				</xsl:if>
				<xsl:if test="count(dc:source) > '0'">
					<tr>
						<td>Source</td>
						<td>
							<xsl:for-each select="dc:source">
								<xsl:value-of select="."/><br/>
							</xsl:for-each>
						</td>
					</tr>
					<xsl:call-template name="separator"/>
				</xsl:if>
				<xsl:if test="count(dc:relation) > '0'">
					<tr>
						<td>Relation</td>
						<td>
							<xsl:for-each select="dc:relation">
								<xsl:value-of select="."/><br/>
							</xsl:for-each>
						</td>
					</tr>
					<xsl:call-template name="separator"/>
				</xsl:if>
				<xsl:if test="count(dr:repositoryName) > '0'">
					<tr>
						<td>Repository Name</td>
						<td>
							<xsl:for-each select="dr:repositoryName">
								<a href="{$link_repo}"><xsl:value-of select="."/></a><br/>
							</xsl:for-each>
						</td>
					</tr>
					<xsl:call-template name="separator"/>
				</xsl:if>
				<xsl:if test="count(dr:repositoryCountry) > '0'">
					<tr>
						<td>Repository Country</td>
						<td>
							<xsl:for-each select="dr:repositoryCountry">
								<xsl:value-of select="."/><br/>
							</xsl:for-each>
						</td>
					</tr>
					<xsl:call-template name="separator"/>
				</xsl:if>
				<xsl:if test="count(dc:language) > '0'">
					<tr>
						<td>Language</td>
						<td>
							<xsl:for-each select="dc:language">
								<xsl:value-of select="."/><br/>
							</xsl:for-each>
						</td>
					</tr>
					<xsl:call-template name="separator"/>
				</xsl:if>
				<xsl:if test="count(dc:rights) > '0'">
					<tr>
						<td>Rights</td>
						<td>
							<xsl:for-each select="dc:rights">
								<xsl:value-of select="."/><br/>
							</xsl:for-each>
						</td>
					</tr>
					<xsl:call-template name="separator"/>
				</xsl:if>
				<xsl:if test="count(oaf:projectname) > '0'">
					<tr>
						<td><span title="of course this will be a link to the project">Project</span></td>
						<td>
							<xsl:apply-templates select="oaf:projectname" mode="content"/>
						</td>
					</tr>
					<xsl:call-template name="separator"/>
				</xsl:if>
				<xsl:if test="count(oaf:projectdescription) > '0'">
					<tr>
						<td><span title="of course this is only a demo blabla">Project description</span></td>
						<td>
							<xsl:apply-templates select="oaf:projectdescription" mode="content"/>
						</td>
					</tr>
					<xsl:call-template name="separator"/>
				</xsl:if>
				<xsl:if test="count(oaf:subdivisionid) > '0'">
					<tr>
						<td><span>Subdivision</span></td>
						<td>
							<xsl:apply-templates select="oaf:subdivisionid" mode="content"/>
						</td>
					</tr>
					<xsl:call-template name="separator"/>
				</xsl:if>
				<xsl:if test="count(oaf:subdivisionname) > '0'">
					<tr>
						<td><span>Subdivision Name</span></td>
						<td>
							<xsl:apply-templates select="oaf:subdivisionname" mode="content"/>
						</td>
					</tr>
					<xsl:call-template name="separator"/>
				</xsl:if>
			</tbody>
		</table>
	</xsl:template>

	<xsl:template match="dc:creator|dc:contributor|dc:subject" mode="content">
	  <li>
	    <xsl:apply-templates select="." mode="richText" />
	  </li>
	</xsl:template>

	<xsl:template match="*" mode="content">
		<xsl:apply-templates select="." mode="richText" />
		<br />
	</xsl:template>

	<xsl:template match="*" mode="richText">
		<xsl:choose>
			<xsl:when test="contains(text(), '&lt;i&gt;')">
				<xsl:value-of disable-output-escaping="yes" select="." />
			</xsl:when>
			<xsl:otherwise>
				<xsl:value-of select="." />
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	
		<xsl:template name="xmlItem">
		<xsl:param name="indent" />


		<xsl:variable name="tag" select="local-name()" />
		<xsl:variable name="ns" select="namespace-uri()" />
		
		<xsl:variable name="newindent">
			<xsl:value-of select="$indent" />
			&#160;&#160;&#160;&#160;
		</xsl:variable>

		<xsl:variable name="attribs">
			<xsl:for-each select="@*">
				<xsl:value-of select="concat(' ', local-name(), '=&quot;', ., '&quot;')" />
			</xsl:for-each>
		</xsl:variable>
		<xsl:value-of select="$indent" />

		<b>
			<xsl:value-of select="concat('&lt;',$tag)" />
		</b>
		<i>
			<xsl:if test="string-length($ns) &gt; 0">
		    	<xsl:value-of select="concat(' xmlns=&quot;',$ns,'&quot;')" />"
		    </xsl:if>
			<xsl:value-of select="$attribs" />
		</i>
		<b>&gt;</b>

		<xsl:value-of select="text()" />

		<xsl:choose>
			<xsl:when test="count(child::*) &gt; 0">
				<br />
				<xsl:for-each select="child::*">
					<xsl:call-template name="xmlItem">
						<xsl:with-param name="indent" select="$newindent" />
					</xsl:call-template>
					<br />
				</xsl:for-each>
				<xsl:value-of select="$indent" />
			</xsl:when>
			<xsl:otherwise>

			</xsl:otherwise>
		</xsl:choose>

		<b>
			<xsl:value-of select="concat('&lt;/',$tag,'&gt;')" />
		</b>

	</xsl:template>
	
</xsl:stylesheet>
