package eu.dnetlib.functionality.lightui.browse;

import java.util.ArrayList;
import java.util.List;

public class BrowseCategory {
	private String categoryName;
	private List<BrowseValue> values;
	private String baseQuery;
	
	public BrowseCategory(String categoryName, String baseQuery) {
		super();
		this.categoryName = categoryName;
		this.baseQuery = baseQuery;
		this.values = new ArrayList<BrowseValue>();
	}

	public void insertElement(final String valueName, int size) {
		String valueSearch = valueName;

		// Fix for Index Bug
		// valueSearch = valueSearch.replaceAll("\\s*(\\)|\\(|,)\\s*","*");
		// End Fix
		
		String query = "(" + baseQuery + ") AND (" + categoryName + " exact \"" + valueSearch + "\")"; 
		values.add(new BrowseValue(valueName, query, size));
	}
	
	public String getCategoryName() {
		return categoryName;
	}

	public List<BrowseValue> getValues() {
		return values;
	}

	public List<BrowseValue> getMinimalValues() {
		if (values.size() < 6) return values;
		return values.subList(0, 6);
	}
	
	public boolean isMoreElements()  {
		return values.size() >= 6;
	}
	

}
