package eu.dnetlib.functionality.lightui.utils;

import java.util.HashSet;
import java.util.List;
import java.util.Set;

import javax.annotation.Resource;

import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;

import eu.dnetlib.enabling.is.lookup.rmi.ISLookUpDocumentNotFoundException;
import eu.dnetlib.enabling.is.lookup.rmi.ISLookUpException;
import eu.dnetlib.enabling.is.lookup.rmi.ISLookUpService;
import eu.dnetlib.enabling.tools.ServiceLocator;

public class AllRepositoriesCollection extends AbstractQuerable implements DriverCollection, BeanFactoryAware {

	private BeanFactory beanFactory;

	@Resource(name = "lookupLocator")
	ServiceLocator<ISLookUpService> lookupLocator;

	public Set<Repository> getRepositories() throws ISLookUpException {
		final Set<Repository> repositories = new HashSet<Repository>();

		List<String> reps = lookupLocator.getService().quickSearchProfile("for $x in //RESOURCE_PROFILE[.//RESOURCE_TYPE/@value='RepositoryServiceResourceType']" +
				"return concat($x//OFFICIAL_NAME/text(), ':-:', $x//RESOURCE_IDENTIFIER/@value/string())");

		for(String rep : reps) {
			String[] repComponents = rep.split(":-:");
			repositories.add((Repository) beanFactory.getBean("repositoryWithIdImpl", repComponents));
		}

		return repositories;
	}

	public String getQuery() throws ISLookUpDocumentNotFoundException, ISLookUpException {
		return "";
	}

	public BeanFactory getBeanFactory() {
		return beanFactory;
	}

	public void setBeanFactory(BeanFactory beanFactory) {
		this.beanFactory = beanFactory;
	}

	public ServiceLocator<ISLookUpService> getLookupLocator() {
		return lookupLocator;
	}

	public void setLookupLocator(ServiceLocator<ISLookUpService> lookupLocator) {
		this.lookupLocator = lookupLocator;
	}


}
