package eu.dnetlib.functionality.lightui.utils;

import net.sf.ehcache.Cache;
import net.sf.ehcache.Element;

public class EhCacheCachedImageDaoImpl implements CachedImageDao {

	private Cache cache;
	
	public CachedImage getCachedImage(String key) {
		Element element = getCache().get(key);
		if(element == null)
			return null;
		return (CachedImage)element.getValue(); 
	}

	public void putCachedImage(String key, CachedImage cachedImage) {
		getCache().put(new Element(key, cachedImage));
	}

	public Cache getCache() {
		return cache;
	}

	public void setCache(Cache cache) {
		this.cache = cache;
	}

}
