package eu.dnetlib.functionality.lightui.utils.cql;

import java.io.IOException;
import java.util.Collection;

import org.z3950.zing.cql.CQLNode;
import org.z3950.zing.cql.CQLParseException;

/**
 * This query operator is suitable for the "allFields" unnamed field, since it simply splits all the words in the query
 * and chains them in AND clauses.
 *
 * @author marko
 *
 */
public class SplitAndQueryOperator extends AbstractQueryOperator implements QueryOperator {

	public void append(Collection<CQLNode> nodes, String name, String value) throws CQLParseException, IOException {
		for (final String token : value.split(" "))
			nodes.add(getParser().parse("\"" + token + "\""));
	}

}
