package eu.dnetlib.functionality.lightui.web;


import java.util.Map;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.web.servlet.view.AbstractView;

import eu.dnetlib.functionality.lightui.utils.CachedImage;
import eu.dnetlib.functionality.lightui.utils.CachedImageDao;

public class CachedImageView extends AbstractView {
	public static Log log = LogFactory.getLog(CachedImageView.class);

	@Resource
	protected CachedImageDao cachedImageDao;

	@SuppressWarnings("rawtypes")
	@Override
	protected void renderMergedOutputModel(Map map, HttpServletRequest request,
			HttpServletResponse response) throws Exception {

		String url = ((String) map.get("url")).trim();

		CachedImage cachedImage = cachedImageDao.getCachedImage(url);
		if (cachedImage != null) {
			response.setContentType(cachedImage.getContentType());
			response.getOutputStream().write(cachedImage.getData());
		}

	}

}