package eu.dnetlib.functionality.lightui.formatter;

import java.io.IOException;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.Enumeration;

import javax.annotation.PostConstruct;
import javax.servlet.http.HttpSession;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamSource;

import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.core.io.Resource;

public class ResultFormatter {
	protected Log log = LogFactory.getLog(ResultFormatter.class);

	private Resource xsltResource;
	private TransformerFactory tFactory;
	private Transformer transformer;

	private String openIndexTagHL = null;
	private String openHtmlTagHL = null;
	private String closeIndexTagHL = null;
	private String closeHtmlTagHL = null;

	protected ResultFormatter() {
		tFactory = TransformerFactory.newInstance();
	}

	@PostConstruct
	public void init(HttpSession session) {
		try {
			transformer = tFactory.newTransformer(new StreamSource(xsltResource.getInputStream()));
			setSessionParameters(session);
		} catch (TransformerConfigurationException e) {
			throw new IllegalStateException(e);
		} catch (IOException e) {
			throw new IllegalStateException(e);
		}
	}

	public String viewDocument(String docXML) {
		try {
			log.debug("start transforming row result");

			StringWriter strw = new StringWriter();

			transformer.transform(new StreamSource(new StringReader(docXML)),
					new javax.xml.transform.stream.StreamResult(strw));

			String res =  strw.toString();
			
			if (openIndexTagHL != null && openHtmlTagHL != null &&
					closeIndexTagHL != null && closeHtmlTagHL != null	) {
				res = StringUtils.replace(res, openIndexTagHL, openHtmlTagHL);
				res = StringUtils.replace(res, closeIndexTagHL, closeHtmlTagHL);
			}
			
			log.debug("end transforming row result");
			return res;
		} catch (TransformerConfigurationException e) {
			throw new IllegalStateException(e);
		} catch (TransformerException e) {
			throw new IllegalStateException(e);
		}
	}

	public void setSessionParameters(HttpSession session) {
		if (session == null) return;
		Enumeration<?> params = session.getAttributeNames();
		while (params.hasMoreElements()) {
			String name = params.nextElement().toString();
			transformer.setParameter(name, session.getAttribute(name));
		}
	}
	
	public void setXslt(Resource xslt) {
		this.xsltResource = xslt;
		log.info("got XSLT " + xsltResource );
	}

	public String getOpenIndexTagHL() {
		return openIndexTagHL;
	}

	public void setOpenIndexTagHL(String openIndexTagHL) {
		this.openIndexTagHL = openIndexTagHL;
	}

	public String getOpenHtmlTagHL() {
		return openHtmlTagHL;
	}

	public void setOpenHtmlTagHL(String openHtmlTagHL) {
		this.openHtmlTagHL = openHtmlTagHL;
	}

	public String getCloseIndexTagHL() {
		return closeIndexTagHL;
	}

	public void setCloseIndexTagHL(String closeIndexTagHL) {
		this.closeIndexTagHL = closeIndexTagHL;
	}

	public String getCloseHtmlTagHL() {
		return closeHtmlTagHL;
	}

	public void setCloseHtmlTagHL(String closeHtmlTagHL) {
		this.closeHtmlTagHL = closeHtmlTagHL;
	}

	
}
