package eu.dnetlib.functionality.lightui.utils;

import java.io.IOException;
import java.util.Collection;
import java.util.Map;

import org.springframework.beans.factory.annotation.Required;
import org.z3950.zing.cql.CQLNode;
import org.z3950.zing.cql.CQLParseException;

import eu.dnetlib.functionality.lightui.utils.cql.QueryOperator;

/**
 * Configure cql operators to be used with a given field using spring.
 *
 * <p>Inject a map in the 'operators' property, mapping fields to QueryOperators.</p>
 *
 * @author marko
 *
 */
public class ConfigurableQueryBuilder extends AbstractQueryBuilder implements QueryBuilder {

	/**
	 * Operator map. Please declare all fields with the operator you want to be applied to that field.
	 */
	private Map<String, QueryOperator> operators;

	/**
	 * Any field not declared in the 'operators' map will be handled with this default operator
	 */
	private QueryOperator defaultOperator;

	protected void handleField(final Collection<CQLNode> nodes, final String key, final String value) throws CQLParseException, IOException {
		QueryOperator operator = operators.get(key);

		if(operator == null)
			operator = defaultOperator;

		operator.append(nodes, key, value);
	}

	public Map<String, QueryOperator> getOperators() {
		return operators;
	}

	@Required
	public void setOperators(final Map<String, QueryOperator> operators) {
		this.operators = operators;
	}

	@Required
	public QueryOperator getDefaultOperator() {
		return defaultOperator;
	}

	public void setDefaultOperator(final QueryOperator defaultOperator) {
		this.defaultOperator = defaultOperator;
	}

}
