package eu.dnetlib.functionality.lightui.utils;

import java.util.LinkedHashSet;
import java.util.Set;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;

import eu.dnetlib.enabling.is.lookup.rmi.ISLookUpDocumentNotFoundException;
import eu.dnetlib.enabling.is.lookup.rmi.ISLookUpException;

/**
 * A RepositoryDriverCollection is a collections which consists of a selection of 
 * repositories. We can obtain the list of repositories in the collection by parsing
 * the CQL query.
 * 
 * @author marko
 *
 */
public class RepositoryDriverCollection extends DynamicDriverCollection implements BeanFactoryAware {
	public static Log log = LogFactory
			.getLog(RepositoryDriverCollection.class);
	
	private BeanFactory beanFactory;
	
	public Set<Repository> getRepositories() throws ISLookUpDocumentNotFoundException, BeansException, ISLookUpException {
		Set<Repository> repositories = new LinkedHashSet<Repository>();
	
		for (String repository : utils.splitRepository(getQuery())) {
			Repository rep = (Repository) beanFactory.getBean("repositoryImpl", new Object[] {repository});
			repositories.add(rep);
		}
			
		return repositories;
	}

	public void setBeanFactory(BeanFactory beanFactory) throws BeansException {
		this.beanFactory = beanFactory;	
	}
	
}
