package eu.dnetlib.functionality.lightui.utils.cql;

import java.util.Collection;

import org.springframework.beans.factory.annotation.Required;
import org.z3950.zing.cql.CQLNode;
import org.z3950.zing.cql.CQLRelation;
import org.z3950.zing.cql.CQLTermNode;

public class SimpleQueryOperator implements QueryOperator {

	private String operator;

	private String field;

	public void append(final Collection<CQLNode> nodes, final String pname, final String pvalue) {
		String fieldName = pname;
		if(this.field != null && !this.field.equals(""))
			fieldName = this.field;

		nodes.add(new CQLTermNode(fieldName, new CQLRelation(operator), pvalue));
	}

	public String getOperator() {
		return operator;
	}

	@Required
	public void setOperator(final String operator) {
		this.operator = operator;
	}

	public String getField() {
		return field;
	}

	public void setField(final String field) {
		this.field = field;
	}

}
