package eu.dnetlib.functionality.lightui.web;


import java.util.concurrent.Future;

import javax.xml.ws.wsaddressing.W3CEndpointReference;

import eu.dnetlib.data.index.IndexServiceException;
import eu.dnetlib.functionality.lightui.utils.ResultSet;

public interface SearchEngine {

	/**
	 * @param query
	 * @param metadataFormat
	 * @param epr
	 * @return
	 * @throws IndexServiceException 
	 */
	ResultSet resultSetForQueryOrEpr(String query, String metadataFormat, W3CEndpointReference epr) throws IndexServiceException;

	/**
	 * The search engine may need to prepare the query (e.g. execute it in background)
	 * Call this method as soon as the query source is known and the probability that the
	 * query will be actually needed is high.
	 * 
	 * @param cqlQuery
	 * @param metadataFormat
	 * @return
	 */
	Future<ResultSet> prepareQuery(String cqlQuery, String metadataFormat);
}
