package eu.dnetlib.simplesso;

import org.springframework.security.GrantedAuthority;
import org.springframework.security.providers.AbstractAuthenticationToken;

public class SimpleSSOAuthenticationToken extends AbstractAuthenticationToken {

	/**
	 * 
	 */
	private static final long serialVersionUID = 1L;

	private String token;
	
	private String uid;

	public SimpleSSOAuthenticationToken(String token) {
		super(new GrantedAuthority[0]);

		this.token = token;
		setAuthenticated(false);
	}

	public SimpleSSOAuthenticationToken(String token, GrantedAuthority[] grantedAuthorities) {
		super(grantedAuthorities);
		this.token = token;
		
		setAuthenticated(true);
	}

	public Object getCredentials() {
		return null;
	}

	public Object getPrincipal() {
		return uid;
	}

	public String getToken() {
		return token;
	}

	public void setToken(String token) {
		this.token = token;
	}

	public String getUid() {
		return uid;
	}

	public void setUid(String uid) {
		this.uid = uid;
	}

}
