/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.functionality.lightui.utils;

import eu.dnetlib.data.information.publisher.rmi.PublisherService;
import eu.dnetlib.enabling.tools.ServiceLocator;
import eu.dnetlib.functionality.lightui.utils.CachingPublisherClient;
import java.io.Serializable;
import net.sf.ehcache.Cache;
import net.sf.ehcache.Element;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Required;

public class CachingPublisherClientImpl
implements CachingPublisherClient {
    protected Log log = LogFactory.getLog(CachingPublisherClientImpl.class);
    ServiceLocator<PublisherService> publisherLocator;
    private Cache recordCache;

    @Override
    public String getResourceById(String id, String format) {
        this.log.debug((Object)"getting record by id from cache");
        Element element = this.recordCache.get((Serializable)((Object)this.makeCacheKey(id, format)));
        if (element == null) {
            String record = ((PublisherService)this.publisherLocator.getService()).getResourceById(id, format);
            this.updateRecord(id, format, record);
            return record;
        }
        this.log.debug((Object)"found record in cache");
        return (String)element.getObjectValue();
    }

    @Override
    public void updateRecord(String id, String format, String record) {
        this.log.debug((Object)("updating cache for " + id));
        this.recordCache.put(new Element((Serializable)((Object)this.makeCacheKey(id, format)), (Serializable)((Object)record)));
    }

    protected String makeCacheKey(String id, String format) {
        return id + format;
    }

    public Cache getRecordCache() {
        return this.recordCache;
    }

    @Required
    public void setRecordCache(Cache recordCache) {
        this.recordCache = recordCache;
    }

    public ServiceLocator<PublisherService> getPublisherLocator() {
        return this.publisherLocator;
    }

    @Required
    public void setPublisherLocator(ServiceLocator<PublisherService> publisherLocator) {
        this.publisherLocator = publisherLocator;
    }
}

