/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.functionality.lightui.utils;

import eu.dnetlib.functionality.lightui.utils.AbstractQuerable;
import eu.dnetlib.functionality.lightui.utils.CachedImage;
import eu.dnetlib.functionality.lightui.utils.CachedImageDao;
import eu.dnetlib.functionality.lightui.utils.Repository;
import org.apache.commons.httpclient.DefaultHttpMethodRetryHandler;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class RepositoryImpl
extends AbstractQuerable
implements Repository {
    public static Log log = LogFactory.getLog(RepositoryImpl.class);
    private String iconUrl;
    private String url;
    private CachedImageDao cachedImageDao;

    public RepositoryImpl() {
    }

    public RepositoryImpl(String name) {
        this(name, null);
    }

    public RepositoryImpl(String name, String iconUrl) {
        this(name, iconUrl, null);
    }

    public RepositoryImpl(String name, String iconUrl, String url) {
        this.setName(name);
        this.setIconUrl(iconUrl);
        this.setUrl(url);
    }

    @Override
    public String getQuery() {
        return "repositoryName = \"" + this.getName() + "\"";
    }

    private void setIconUrl(String iconUrl) {
        this.iconUrl = iconUrl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getIconUrl() {
        if (this.cachedImageDao.getCachedImage(this.iconUrl) == null) {
            if ("".equals(this.iconUrl)) {
                return "";
            }
            HttpClient client = new HttpClient();
            GetMethod method = new GetMethod(this.iconUrl);
            method.getParams().setParameter("http.method.retry-handler", (Object)new DefaultHttpMethodRetryHandler(3, false));
            try {
                client.executeMethod((HttpMethod)method);
                String contentType = method.getResponseHeaders("content-type")[0].getValue();
                this.cachedImageDao.putCachedImage(this.iconUrl, new CachedImage(method.getResponseBody(), contentType));
            }
            catch (Exception e) {
                log.warn((Object)("Cannot cache image: " + this.iconUrl));
                e.printStackTrace();
            }
            finally {
                method.releaseConnection();
            }
        }
        return this.iconUrl;
    }

    @Override
    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public CachedImageDao getCachedImageDao() {
        return this.cachedImageDao;
    }

    public void setCachedImageDao(CachedImageDao cachedImageDao) {
        this.cachedImageDao = cachedImageDao;
    }
}

