<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
	<xsl:output method="html" version="1.0" encoding="UTF-8" indent="yes"/>
	<xsl:template match="/">
		<xsl:apply-templates select="//metadata"/>
	</xsl:template>
	<xsl:template match="//metadata">
		<xsl:variable name = "link_repo" select = "*[name()='dr:repositoryLink']"></xsl:variable>
	
		<xsl:for-each select="*[name()='dr:repositoryName']">
			<h3><xsl:value-of select="."/></h3>
		</xsl:for-each>
		<xsl:for-each select="*[name()='dc:title']">
			<h4><xsl:apply-templates select="." mode="richText"/></h4>
		</xsl:for-each>
		<br/>
		<table class="listing" width="100%">
			<tbody>
				<tr>
					<td colspan="3" class="headseparator"><xsl:text>  </xsl:text></td>
				</tr>
				<tr class="heading" valign="top">
					<td width="25%">Field</td>
					<td width="75%">Value</td>
				</tr>
				<tr>
					<td colspan="3" class="headseparator"><xsl:text>  </xsl:text></td>
				</tr>
				<xsl:if test="count(*[name()='dc:title']) > '0'">
					<tr>
						<td>Title</td>
						<td>
							<xsl:apply-templates select="*[name()='dc:title']" mode="content"/>
						</td>
					</tr>
					<tr>
						<td colspan="3" class="separator"><xsl:text>  </xsl:text></td>
					</tr>
				</xsl:if>
				<xsl:if test="count(*[name()='dc:creator']) > '0'">
					<tr>
						<td>Author</td>
						<td>
						  <ul class="authorList">
						    <xsl:apply-templates select="*[name()='dc:creator']" mode="content"/>
						  </ul>
						</td>
					</tr>
					<tr>
						<td colspan="3" class="separator"><xsl:text>  </xsl:text></td>
					</tr>
				</xsl:if>
				<xsl:if test="count(*[name()='dc:contributor']) > '0'">
					<tr>
						<td>Contributor</td>
						<td>
						  <ul class="authorList">
						    <xsl:apply-templates select="*[name()='dc:contributor']" mode="content"/>
						  </ul>
						</td>
					</tr>
					<tr>
						<td colspan="3" class="separator"><xsl:text>  </xsl:text></td>
					</tr>
				</xsl:if>
				<xsl:if test="count(*[name()='dc:subject']) > '0'">
					<tr>
						<td>Subject</td>
						<td>
   						<ul class="subjectList">
						    <xsl:apply-templates select="*[name()='dc:subject']" mode="content"/>
						  </ul>
						</td>
					</tr>
					<tr>
						<td colspan="3" class="separator"><xsl:text>  </xsl:text></td>
					</tr>
				</xsl:if>
				<xsl:if test="count(*[name()='dc:description']) > '0'">
					<tr>
						<td>Description</td>
						<td>
						  <xsl:apply-templates select="*[name()='dc:description']" mode="content"/>
						</td>
					</tr>
					<tr>
						<td colspan="3" class="separator"><xsl:text>  </xsl:text></td>
					</tr>
				</xsl:if>
				<xsl:if test="count(*[name()='dc:publisher']) > '0'">
					<tr>
						<td>Institution</td>
						<td>
							<xsl:for-each select="*[name()='dc:publisher']">
								<xsl:value-of select="."/><br/>
							</xsl:for-each>
						</td>
					</tr>
					<tr>
						<td colspan="3" class="separator"><xsl:text>  </xsl:text></td>
					</tr>
				</xsl:if>
				<xsl:if test="count(*[name()='dc:dateAccepted']) > '0'">
					<tr>
						<td>Date</td>
						<td>
							<xsl:for-each select="*[name()='dc:dateAccepted']">
								<xsl:value-of select="."/><br/>
							</xsl:for-each>
						</td>
					</tr>
					<tr>
						<td colspan="3" class="separator"><xsl:text>  </xsl:text></td>
					</tr>
				</xsl:if>
				<xsl:if test="count(*[name()='dc:format']) > '0'">
					<tr>
						<td>Format</td>
						<td>
							<xsl:for-each select="*[name()='dc:format']">
								<xsl:value-of select="."/><br/>
							</xsl:for-each>
						</td>
					</tr>
					<tr>
						<td colspan="3" class="separator"><xsl:text>  </xsl:text></td>
					</tr>
				</xsl:if>
				<xsl:if test="count(*[name()='dc:identifier']) > '0'">
					<tr>
						<td>URL</td>
						<td>
							<xsl:for-each select="*[name()='dc:identifier']">
								<xsl:variable name = "link" select = "."></xsl:variable>
								<a href="{$link}"><xsl:value-of select="."/></a><br/>
							</xsl:for-each>
						</td>
					</tr>
					<tr>
						<td colspan="3" class="separator"><xsl:text>  </xsl:text></td>
					</tr>
				</xsl:if>
				<xsl:if test="count(*[name()='dc:type']) > '0'">
					<tr>
						<td>Type</td>
						<td>
							<xsl:for-each select="*[name()='dc:type']">
								<xsl:value-of select="."/><br/>
							</xsl:for-each>
						</td>
					</tr>
					<tr>
						<td colspan="3" class="separator"><xsl:text>  </xsl:text></td>
					</tr>
				</xsl:if>
				<xsl:if test="count(*[name()='dc:source']) > '0'">
					<tr>
						<td>Source</td>
						<td>
							<xsl:for-each select="*[name()='dc:source']">
								<xsl:value-of select="."/><br/>
							</xsl:for-each>
						</td>
					</tr>
					<tr>
						<td colspan="3" class="separator"><xsl:text>  </xsl:text></td>
					</tr>
				</xsl:if>
				<xsl:if test="count(*[name()='dc:relation']) > '0'">
					<tr>
						<td>Relation</td>
						<td>
							<xsl:for-each select="*[name()='dc:relation']">
								<xsl:value-of select="."/><br/>
							</xsl:for-each>
						</td>
					</tr>
					<tr>
						<td colspan="3" class="separator"><xsl:text>  </xsl:text></td>
					</tr>
				</xsl:if>
				<xsl:if test="count(*[name()='dr:repositoryName']) > '0'">
					<tr>
						<td>Repository Name</td>
						<td>
							<xsl:for-each select="*[name()='dr:repositoryName']">
								<a href="{$link_repo}"><xsl:value-of select="."/></a><br/>
							</xsl:for-each>
						</td>
					</tr>
					<tr>
						<td colspan="3" class="separator"><xsl:text>  </xsl:text></td>
					</tr>
				</xsl:if>
				<xsl:if test="count(*[name()='dr:repositoryCountry']) > '0'">
					<tr>
						<td>Repository Country</td>
						<td>
							<xsl:for-each select="*[name()='dr:repositoryCountry']">
								<xsl:value-of select="."/><br/>
							</xsl:for-each>
						</td>
					</tr>
					<tr>
						<td colspan="3" class="separator"><xsl:text>  </xsl:text></td>
					</tr>
				</xsl:if>
				<xsl:if test="count(*[name()='dc:language']) > '0'">
					<tr>
						<td>Language</td>
						<td>
							<xsl:for-each select="*[name()='dc:language']">
								<xsl:value-of select="."/><br/>
							</xsl:for-each>
						</td>
					</tr>
					<tr>
						<td colspan="3" class="separator"><xsl:text>  </xsl:text></td>
					</tr>
				</xsl:if>
				<xsl:if test="count(*[name()='dc:rights']) > '0'">
					<tr>
						<td>Rights</td>
						<td>
							<xsl:for-each select="*[name()='dc:rights']">
								<xsl:value-of select="."/><br/>
							</xsl:for-each>
						</td>
					</tr>
					<tr>
						<td colspan="3" class="separator"><xsl:text>  </xsl:text></td>
					</tr>
				</xsl:if>
			</tbody>
		</table>
	</xsl:template>

	<xsl:template match="*[name()='dc:creator' or name()='dc:contributor' or name()='dc:subject']" mode="content">
	  <li>
	    <xsl:apply-templates select="." mode="richText" />
	  </li>
	</xsl:template>

	<xsl:template match="*" mode="content">
		<xsl:apply-templates select="." mode="richText" />
		<br />
	</xsl:template>

	<xsl:template match="*" mode="richText">
		<xsl:choose>
			<xsl:when test="contains(text(), '&lt;i&gt;')">
				<xsl:value-of disable-output-escaping="yes" select="." />
			</xsl:when>
			<xsl:otherwise>
				<xsl:value-of select="." />
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
</xsl:stylesheet>
