package eu.dnetlib.enabling.inspector;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;

import eu.dnetlib.management.log4j.Log4JMBean;

@Controller
public class Log4jInspector extends AbstractInspectorController {

	@Autowired
	private Log4JMBean log4jmBean;

	@RequestMapping(value = "/inspector/log4j.do", method = RequestMethod.GET)
	public void log4j(final Model model) {

	}

	@RequestMapping(value = "/inspector/log4j.do", method = RequestMethod.POST)
	public String log4j(final Model model,
			@RequestParam(value = "classname", required = false) final String classname,
			@RequestParam(value = "level", required = false) final String level) {

		if ((classname != null) && (level != null)) {
			log4jmBean.setLogger(classname, level);
			// LogManager.getLogger(classname).setLevel(Level.toLevel(level));
			// model.addAttribute("message", "Log level for: " + classname + " set to: " + level);
		}
		return "redirect:log4j.do";
	}

}
